/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.kernel;

import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTrustManager
implements X509TrustManager {
    private final X509TrustManager tm;
    private final List<X509CRL> crls;

    public CompositeTrustManager(X509TrustManager tm, List<X509CRL> crls) {
        this.tm = tm;
        this.crls = crls;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String s) throws CertificateException {
        this.tm.checkClientTrusted(certs, s);
        this.checkCRL(certs);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String s) throws CertificateException {
        this.tm.checkServerTrusted(certs, s);
        this.checkCRL(certs);
    }

    private void checkCRL(X509Certificate[] certs) throws CertificateException {
        for (X509Certificate cert : certs) {
            for (X509CRL crl : this.crls) {
                if (!crl.isRevoked(cert)) continue;
                throw new CertificateException("Certificate not trusted per the CRL");
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }
}

