/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.search.groups;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.ParsableFactory;
import io.apicurio.registry.rest.client.models.GroupSearchResults;
import io.apicurio.registry.rest.client.models.GroupSortBy;
import io.apicurio.registry.rest.client.models.ProblemDetails;
import io.apicurio.registry.rest.client.models.SortOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class GroupsRequestBuilder
extends BaseRequestBuilder {
    public GroupsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/search/groups{?description*,groupId*,labels*,limit*,offset*,order*,orderby*}", pathParameters);
    }

    public GroupsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/search/groups{?description*,groupId*,labels*,limit*,offset*,order*,orderby*}", rawUrl);
    }

    @Nullable
    public GroupSearchResults get() {
        return this.get(null);
    }

    @Nullable
    public GroupSearchResults get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("500", ProblemDetails::createFromDiscriminatorValue);
        return (GroupSearchResults)this.requestAdapter.send(requestInfo, errorMapping, GroupSearchResults::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public GroupsRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new GroupsRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String description;
        @Nullable
        public String groupId;
        @Nullable
        public String[] labels;
        @Nullable
        public Integer limit;
        @Nullable
        public Integer offset;
        @Nullable
        public SortOrder order;
        @Nullable
        public GroupSortBy orderby;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("order", (Object)this.order);
            allQueryParams.put("orderby", (Object)this.orderby);
            allQueryParams.put("description", this.description);
            allQueryParams.put("groupId", this.groupId);
            allQueryParams.put("limit", this.limit);
            allQueryParams.put("offset", this.offset);
            allQueryParams.put("labels", this.labels);
            return allQueryParams;
        }
    }
}

