/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.support.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.alauda.jenkins.devops.support.KubernetesCluster;
import io.alauda.jenkins.devops.support.exception.KubernetesClientException;
import io.alauda.jenkins.devops.support.utils.CredentialsUtils;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.util.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import okio.Buffer;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.remoting.util.Charsets;

public final class Clients {
    private static final Logger logger = Logger.getLogger(Clients.class.getName());

    private Clients() {
    }

    @Nonnull
    public static ApiClient createClientFromCluster(@Nonnull KubernetesCluster cluster) throws KubernetesClientException {
        if (StringUtils.isEmpty((String)cluster.getMasterUrl())) {
            try {
                ApiClient client = Config.fromCluster();
                return client;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, String.format("Unable to create a client from local cluster, reason %s", e.getMessage()), e);
                throw new KubernetesClientException(e);
            }
        }
        String token = "";
        try {
            token = StringUtils.isEmpty((String)cluster.getCredentialsId()) ? Clients.getTokenFromLocalCluster() : CredentialsUtils.getToken(cluster.getCredentialsId());
        }
        catch (IOException | GeneralSecurityException e) {
            logger.log(Level.WARNING, String.format("Unable to get token for k8s client, reason %s", e.getMessage()), e);
        }
        ApiClient client = Config.fromToken((String)cluster.getMasterUrl(), (String)token, (!cluster.isSkipTlsVerify() ? 1 : 0) != 0);
        if (!cluster.isSkipTlsVerify()) {
            try {
                Buffer buffer = new Buffer();
                if (!StringUtils.isEmpty((String)cluster.getServerCertificateAuthority())) {
                    if (new File(cluster.getServerCertificateAuthority()).isFile()) {
                        buffer.write(Files.readAllBytes(Paths.get(cluster.getServerCertificateAuthority(), new String[0])));
                    } else {
                        buffer.writeUtf8(cluster.getServerCertificateAuthority());
                    }
                } else {
                    buffer.writeUtf8(Clients.getCAFromLocalCluster());
                }
                if (buffer.size() != 0L) {
                    client.setSslCaCert(buffer.inputStream());
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, String.format("Unable to get ca for k8s client, reason %s", e.getMessage()), e);
            }
        }
        return client;
    }

    public static ApiClient createClientFromConfig(String masterUrl, String credentialsId, String serverCertificateAuthority, boolean skipTlsVerify) throws KubernetesClientException {
        KubernetesCluster cluster = new KubernetesCluster();
        cluster.setMasterUrl(masterUrl);
        cluster.setCredentialsId(credentialsId);
        cluster.setServerCertificateAuthority(serverCertificateAuthority);
        cluster.setSkipTlsVerify(skipTlsVerify);
        return Clients.createClientFromCluster(cluster);
    }

    @Nonnull
    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="I know what I'm doing")
    private static String getTokenFromLocalCluster() throws IOException {
        if (Files.exists(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]), new LinkOption[0])) {
            return new String(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0])), Charsets.UTF_8);
        }
        throw new FileNotFoundException(String.format("Unable to get token from %s", "/var/run/secrets/kubernetes.io/serviceaccount/token"));
    }

    @Nonnull
    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="I know what I'm doing")
    private static String getCAFromLocalCluster() throws IOException {
        if (Files.exists(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0]), new LinkOption[0])) {
            return new String(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0])), Charsets.UTF_8);
        }
        throw new FileNotFoundException(String.format("Unable to get CA from %s", "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt"));
    }
}

