/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Result;
import hudson.model.Run;
import io.alauda.devops.java.client.models.V1alpha1Pipeline;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.kubernetes.client.models.V1Status;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;

public class PipelineUtils {
    private static final Logger logger = Logger.getLogger(PipelineUtils.class.getName());

    public static TreeSet<JenkinsPipelineCause> findAllAlaudaCauses(Actionable actionable) {
        TreeSet<JenkinsPipelineCause> pipelineCauses = new TreeSet<JenkinsPipelineCause>((a, b) -> {
            if (a == null || a.getName() == null) {
                return 1;
            }
            if (b == null || b.getName() == null) {
                return -1;
            }
            return a.getName().compareTo(b.getName());
        });
        if (actionable == null) {
            return pipelineCauses;
        }
        ArrayList causes = new ArrayList();
        List causeActions = actionable.getActions(CauseAction.class);
        for (CauseAction causeAction : causeActions) {
            causes.addAll(causeAction.getCauses());
        }
        for (Action action : actionable.getAllActions()) {
            if (!(action instanceof CauseAction)) continue;
            causes.addAll(((CauseAction)action).getCauses());
        }
        if (actionable instanceof Run) {
            causes.addAll(((Run)actionable).getCauses());
        }
        for (Cause cause : causes) {
            if (!(cause instanceof JenkinsPipelineCause)) continue;
            pipelineCauses.add((JenkinsPipelineCause)cause);
        }
        return pipelineCauses;
    }

    public static JenkinsPipelineCause findAlaudaCause(Actionable actionable) {
        TreeSet<JenkinsPipelineCause> pipelineCauses = PipelineUtils.findAllAlaudaCauses(actionable);
        return pipelineCauses.isEmpty() ? null : pipelineCauses.first();
    }

    public static V1Status delete(String namespace, String name) {
        return Clients.get(V1alpha1Pipeline.class).delete(namespace, name);
    }

    public static String runToPipelinePhase(Run run) {
        if (run != null && !run.hasntStartedYet()) {
            if (run.isBuilding()) {
                return "Running";
            }
            Result result = run.getResult();
            if (result != null) {
                if (result.equals(Result.SUCCESS)) {
                    return "Complete";
                }
                if (result.equals(Result.ABORTED)) {
                    return "Cancelled";
                }
                if (result.equals(Result.FAILURE)) {
                    return "Failed";
                }
                if (result.equals(Result.UNSTABLE)) {
                    return "Failed";
                }
                return "Queued";
            }
        }
        return "Pending";
    }
}

