/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import antlr.ANTLRException;
import hudson.scheduler.CronTab;
import hudson.scheduler.CronTabList;
import hudson.scheduler.Hash;
import hudson.scheduler.Messages;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class CronUtils {
    private final Vector<CronTab> tabs;

    public CronUtils(Collection<CronTab> tabs) {
        this.tabs = new Vector<CronTab>(tabs);
    }

    public static CronUtils create(@Nonnull String format, Hash hash) throws ANTLRException {
        Vector<CronTab> r = new Vector<CronTab>();
        int lineNumber = 0;
        String timezone = null;
        for (String line : format.split("\\r?\\n")) {
            line = line.trim();
            if (++lineNumber == 1 && line.startsWith("TZ=")) {
                timezone = CronTabList.getValidTimezone((String)line.replace("TZ=", ""));
                if (timezone != null) continue;
                throw new ANTLRException("Invalid or unsupported timezone '" + timezone + "'");
            }
            if (line.length() == 0 || line.startsWith("#")) continue;
            try {
                r.add(new CronTab(line, lineNumber, hash, timezone));
            }
            catch (ANTLRException e) {
                throw new ANTLRException(Messages.CronTabList_InvalidInput((Object)line, (Object)e.toString()), (Throwable)e);
            }
        }
        return new CronUtils(r);
    }

    @CheckForNull
    public Calendar previous() {
        Calendar nearest = null;
        Iterator<CronTab> iterator = this.tabs.iterator();
        while (iterator.hasNext()) {
            CronTab tab;
            Calendar scheduled = tab.floor((tab = iterator.next()).getTimeZone() == null ? Calendar.getInstance() : Calendar.getInstance(tab.getTimeZone()));
            if (nearest != null && !nearest.before(scheduled)) continue;
            nearest = scheduled;
        }
        return nearest;
    }

    @CheckForNull
    public Calendar next() {
        Calendar nearest = null;
        Iterator<CronTab> iterator = this.tabs.iterator();
        while (iterator.hasNext()) {
            CronTab tab;
            Calendar scheduled = tab.ceil((tab = iterator.next()).getTimeZone() == null ? Calendar.getInstance() : Calendar.getInstance(tab.getTimeZone()));
            if (nearest != null && !nearest.after(scheduled)) continue;
            nearest = scheduled;
        }
        return nearest;
    }

    public String checkSanity() {
        for (CronTab tab : this.tabs) {
            String s = tab.checkSanity();
            if (s == null) continue;
            return s;
        }
        return null;
    }
}

