/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.listener;

import hudson.Extension;
import hudson.model.Actionable;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.util.PipelineUtils;
import java.util.logging.Logger;

@Extension
public class PipelineQueueListener
extends QueueListener {
    private static final Logger logger = Logger.getLogger(PipelineQueueListener.class.getName());

    public void onLeft(Queue.LeftItem leftItem) {
        logger.info(leftItem + " was left");
        boolean isCancelled = leftItem.isCancelled();
        if (!isCancelled) {
            return;
        }
        JenkinsPipelineCause pipelineCause = PipelineUtils.findAlaudaCause((Actionable)leftItem);
        if (pipelineCause != null) {
            String namespace = pipelineCause.getNamespace();
            String name = pipelineCause.getName();
            PipelineUtils.delete(namespace, name);
            logger.info(String.format("Pipeline %s-%s was deleted.", namespace, name));
        } else {
            String itemUrl = leftItem.getUrl();
            logger.warning("Can not found JenkinsPipelineCause, item url: " + itemUrl);
        }
    }
}

