/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.credential;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import hudson.Extension;
import io.alauda.jenkins.plugins.credentials.SecretUtils;
import io.alauda.jenkins.plugins.credentials.convertor.CredentialsConversionException;
import io.alauda.jenkins.plugins.credentials.convertor.SecretToCredentialConverter;
import io.kubernetes.client.models.V1Secret;
import java.util.Optional;

@Extension
public class SSHAuthCredentialsConverter
extends SecretToCredentialConverter {
    public boolean canConvert(String s) {
        return "kubernetes.io/ssh-auth".equals(s);
    }

    public IdCredentials convert(V1Secret secret) throws CredentialsConversionException {
        SecretUtils.requireNonNull((Object)secret.getData(), (String)"kubernetes.io/ssh-auth definition contains no data");
        String privateKey = SecretUtils.getNonNullSecretData((V1Secret)secret, (String)"ssh-privatekey", (String)"kubernetes.io/ssh-auth credential is missing the ssh-privatekey");
        Optional optUsername = SecretUtils.getOptionalSecretData((V1Secret)secret, (String)"username", (String)"kubernetes.io/ssh-auth credential is missing the username");
        Optional optPassphrase = SecretUtils.getOptionalSecretData((V1Secret)secret, (String)"passphrase", (String)"basicSSHUserPrivateKey credential: failed to retrieve passphrase, assuming private key has an empty passphrase");
        String passphrase = null;
        if (optPassphrase.isPresent()) {
            passphrase = (String)SecretUtils.requireNonNull(optPassphrase.get(), (String)"basicSSHUserPrivateKey credential has an invalid passphrase (must be base64 encoded UTF-8)");
        }
        return new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, SecretUtils.getCredentialId((V1Secret)secret), optUsername.orElse(""), (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(privateKey), passphrase, SecretUtils.getCredentialDescription((V1Secret)secret));
    }
}

