/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ItemGroup;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import io.alauda.devops.java.client.models.V1alpha1Pipeline;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.jenkins.devops.sync.AlaudaJobProperty;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.MultiBranchProperty;
import io.alauda.jenkins.devops.sync.SCMRevisionAction;
import io.alauda.jenkins.devops.sync.WorkflowJobProperty;
import io.alauda.jenkins.devops.sync.action.AlaudaQueueAction;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.listener.PipelineSyncRunListener;
import io.alauda.jenkins.devops.sync.util.PipelineGenerator;
import io.alauda.jenkins.devops.sync.util.PipelineToActionMapper;
import io.kubernetes.client.ApiException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

@Extension
public class PipelineDecisionHandler
extends Queue.QueueDecisionHandler {
    private static final Logger LOGGER = Logger.getLogger(PipelineDecisionHandler.class.getName());

    public boolean shouldSchedule(Queue.Task p, List<Action> actions) {
        if (!(p instanceof WorkflowJob)) {
            return true;
        }
        if (PipelineDecisionHandler.triggerFromJenkins(actions)) {
            V1alpha1Pipeline pipeline;
            WorkflowJob workflowJob = (WorkflowJob)p;
            String taskName = p.getName();
            AlaudaJobProperty alaudaJobProperty = this.isMultiBranch(workflowJob) ? (AlaudaJobProperty)((WorkflowMultiBranchProject)workflowJob.getParent()).getProperties().get(MultiBranchProperty.class) : (AlaudaJobProperty)workflowJob.getProperty(WorkflowJobProperty.class);
            if (!this.isValidProperty(alaudaJobProperty)) {
                return true;
            }
            String namespace = alaudaJobProperty.getNamespace();
            String name = alaudaJobProperty.getName();
            String jobURL = this.getJobUrl(workflowJob, namespace);
            LOGGER.info(() -> "Got this namespace " + namespace + " from this alaudaJobProperty: " + name);
            V1alpha1PipelineConfig config = null;
            config = (V1alpha1PipelineConfig)Clients.get(V1alpha1PipelineConfig.class).lister().namespace(namespace).get(name);
            if (config == null) {
                return false;
            }
            if (config.getMetadata() == null) {
                LOGGER.warning("PipelineConfig metadata is null");
                return false;
            }
            try {
                pipeline = PipelineGenerator.buildPipeline(config, workflowJob, jobURL, actions);
            }
            catch (ApiException e) {
                LOGGER.log(Level.WARNING, String.format("Unable to create Pipeline '%s/%s', reason: %s", namespace, config.getMetadata().getName(), e.getMessage()), e);
                return false;
            }
            actions.add((Action)new CauseAction((Cause)new JenkinsPipelineCause(pipeline, config.getMetadata().getUid())));
            actions.add((Action)new AlaudaQueueAction());
            ParametersAction params = PipelineDecisionHandler.dumpParams(actions);
            if (params != null) {
                LOGGER.fine(() -> "ParametersAction: " + params.toString());
                PipelineToActionMapper.addParameterAction(pipeline.getMetadata().getName(), params);
            } else {
                LOGGER.log(Level.FINE, "The param is null in task : {0}", taskName);
            }
            CauseAction cause = this.dumpCause(actions);
            if (cause != null) {
                LOGGER.fine(() -> "get CauseAction: " + cause.getDisplayName());
                for (Cause c : cause.getCauses()) {
                    LOGGER.fine(() -> "Cause: " + c.getShortDescription());
                }
                ArrayList<SCMRevisionAction> causes = new ArrayList<SCMRevisionAction>(cause.getCauses());
                for (Action action : actions) {
                    if (!(action instanceof SCMRevisionAction)) continue;
                    causes.add((SCMRevisionAction)action);
                    break;
                }
                PipelineToActionMapper.addCauseAction(pipeline.getMetadata().getName(), new CauseAction(causes));
            } else {
                LOGGER.fine(() -> "Get null CauseAction in task : " + taskName);
            }
        }
        return true;
    }

    private boolean isMultiBranch(WorkflowJob wfJob) {
        ItemGroup parent = wfJob.getParent();
        return parent instanceof WorkflowMultiBranchProject;
    }

    private String getJobUrl(WorkflowJob workflowJob, String namespace) {
        String jenkinsUrl = "";
        return PipelineSyncRunListener.joinPaths(jenkinsUrl, workflowJob.getUrl());
    }

    private boolean isValidProperty(AlaudaJobProperty property) {
        if (property == null) {
            return false;
        }
        return StringUtils.isNotBlank((String)property.getNamespace()) && StringUtils.isNotBlank((String)property.getName());
    }

    private static boolean triggerFromJenkins(@Nonnull List<Action> actions) {
        return !PipelineDecisionHandler.triggerFromPlatform(actions);
    }

    private static boolean triggerFromPlatform(@Nonnull List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof CauseAction)) continue;
            CauseAction causeAction = (CauseAction)action;
            for (Cause cause : causeAction.getCauses()) {
                if (!(cause instanceof JenkinsPipelineCause)) continue;
                return true;
            }
        }
        return false;
    }

    private CauseAction dumpCause(List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof CauseAction)) continue;
            CauseAction causeAction = (CauseAction)action;
            if (LOGGER.isLoggable(Level.FINE)) {
                for (Cause cause : causeAction.getCauses()) {
                    LOGGER.fine(() -> "cause: " + cause.getShortDescription());
                }
            }
            return causeAction;
        }
        return null;
    }

    private static ParametersAction dumpParams(List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof ParametersAction)) continue;
            ParametersAction paramAction = (ParametersAction)action;
            if (LOGGER.isLoggable(Level.FINE)) {
                for (ParameterValue param : paramAction.getAllParameters()) {
                    LOGGER.fine(() -> "param name " + param.getName() + " param value " + param.getValue());
                }
            }
            return paramAction;
        }
        return null;
    }
}

