/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Objects;

public final class XxHash64 {
    private static final long PRIME64_1 = -7046029288634856825L;
    private static final long PRIME64_2 = -4417276706812531889L;
    private static final long PRIME64_3 = 1609587929392839161L;
    private static final long PRIME64_4 = -8796714831421723037L;
    private static final long PRIME64_5 = 2870177450012600261L;
    private static final long DEFAULT_SEED = 0L;
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private final long seed;
    private final byte[] buffer = new byte[32];
    private int bufferSize;
    private long bodyLength;
    private long v1;
    private long v2;
    private long v3;
    private long v4;

    public XxHash64() {
        this(0L);
    }

    public XxHash64(long seed) {
        this.seed = seed;
        this.v1 = seed + -7046029288634856825L + -4417276706812531889L;
        this.v2 = seed + -4417276706812531889L;
        this.v3 = seed;
        this.v4 = seed - -7046029288634856825L;
    }

    public XxHash64 update(byte[] data) {
        return this.update(data, 0, data.length);
    }

    public XxHash64 update(byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        this.updateHash(data, offset, length);
        return this;
    }

    public XxHash64 update(Slice data) {
        return this.update(data, 0, data.length());
    }

    public XxHash64 update(Slice data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length());
        this.updateHash(data.byteArray(), data.byteArrayOffset() + offset, length);
        return this;
    }

    public long hash() {
        long hash = this.bodyLength > 0L ? this.computeBody() : this.seed + 2870177450012600261L;
        return XxHash64.updateTail(hash += this.bodyLength + (long)this.bufferSize, this.buffer, 0, this.bufferSize);
    }

    private long computeBody() {
        long hash = Long.rotateLeft(this.v1, 1) + Long.rotateLeft(this.v2, 7) + Long.rotateLeft(this.v3, 12) + Long.rotateLeft(this.v4, 18);
        hash = XxHash64.update(hash, this.v1);
        hash = XxHash64.update(hash, this.v2);
        hash = XxHash64.update(hash, this.v3);
        hash = XxHash64.update(hash, this.v4);
        return hash;
    }

    private void updateHash(byte[] base, int offset, int length) {
        if (this.bufferSize > 0) {
            int available = Math.min(32 - this.bufferSize, length);
            System.arraycopy(base, offset, this.buffer, this.bufferSize, available);
            this.bufferSize += available;
            offset += available;
            length -= available;
            if (this.bufferSize == 32) {
                this.updateBody(this.buffer, 0, this.bufferSize);
                this.bufferSize = 0;
            }
        }
        if (length >= 32) {
            int index = this.updateBody(base, offset, length);
            offset += index;
            length -= index;
        }
        if (length > 0) {
            System.arraycopy(base, offset, this.buffer, 0, length);
            this.bufferSize = length;
        }
    }

    private int updateBody(byte[] base, int offset, int length) {
        int remaining;
        for (remaining = length; remaining >= 32; remaining -= 32) {
            this.v1 = XxHash64.mix(this.v1, LONG_HANDLE.get(base, offset));
            this.v2 = XxHash64.mix(this.v2, LONG_HANDLE.get(base, offset + 8));
            this.v3 = XxHash64.mix(this.v3, LONG_HANDLE.get(base, offset + 16));
            this.v4 = XxHash64.mix(this.v4, LONG_HANDLE.get(base, offset + 24));
            offset += 32;
        }
        int index = length - remaining;
        this.bodyLength += (long)index;
        return index;
    }

    public static long hash(long value) {
        return XxHash64.hash(0L, value);
    }

    public static long hash(long seed, long value) {
        long hash = seed + 2870177450012600261L + 8L;
        hash = XxHash64.updateTail(hash, value);
        hash = XxHash64.finalShuffle(hash);
        return hash;
    }

    public static long hash(InputStream in) throws IOException {
        return XxHash64.hash(0L, in);
    }

    public static long hash(long seed, InputStream in) throws IOException {
        int length;
        XxHash64 hash = new XxHash64(seed);
        byte[] buffer = new byte[8192];
        while ((length = in.read(buffer)) != -1) {
            hash.update(buffer, 0, length);
        }
        return hash.hash();
    }

    public static long hash(byte[] data) {
        return XxHash64.hash(0L, data, 0, data.length);
    }

    public static long hash(byte[] data, int offset, int length) {
        return XxHash64.hash(0L, data, offset, length);
    }

    public static long hash(long seed, byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        return XxHash64.hashBytes(seed, data, offset, length);
    }

    public static long hash(Slice data) {
        return XxHash64.hash(data, 0, data.length());
    }

    public static long hash(long seed, Slice data) {
        return XxHash64.hash(seed, data, 0, data.length());
    }

    public static long hash(Slice data, int offset, int length) {
        return XxHash64.hash(0L, data, offset, length);
    }

    public static long hash(long seed, Slice data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length());
        return XxHash64.hashBytes(seed, data.byteArray(), data.byteArrayOffset() + offset, length);
    }

    private static long hashBytes(long seed, byte[] base, int index, int length) {
        long hash;
        int end = index + length;
        if (length >= 32) {
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            while (index <= end - 32) {
                v1 = XxHash64.mix(v1, LONG_HANDLE.get(base, index));
                v2 = XxHash64.mix(v2, LONG_HANDLE.get(base, index + 8));
                v3 = XxHash64.mix(v3, LONG_HANDLE.get(base, index + 16));
                v4 = XxHash64.mix(v4, LONG_HANDLE.get(base, index + 24));
                index += 32;
            }
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            hash = XxHash64.update(hash, v1);
            hash = XxHash64.update(hash, v2);
            hash = XxHash64.update(hash, v3);
            hash = XxHash64.update(hash, v4);
        } else {
            hash = seed + 2870177450012600261L;
        }
        hash += (long)length;
        while (index <= end - 8) {
            hash = XxHash64.updateTail(hash, LONG_HANDLE.get(base, index));
            index += 8;
        }
        if (index <= end - 4) {
            hash = XxHash64.updateTail(hash, INT_HANDLE.get(base, index));
            index += 4;
        }
        while (index < end) {
            hash = XxHash64.updateTail(hash, base[index]);
            ++index;
        }
        return XxHash64.finalShuffle(hash);
    }

    private static long updateTail(long hash, byte[] base, int index, int length) {
        int end = index + length;
        while (index <= end - 8) {
            hash = XxHash64.updateTail(hash, LONG_HANDLE.get(base, index));
            index += 8;
        }
        if (index <= end - 4) {
            hash = XxHash64.updateTail(hash, INT_HANDLE.get(base, index));
            index += 4;
        }
        while (index < end) {
            hash = XxHash64.updateTail(hash, base[index]);
            ++index;
        }
        return XxHash64.finalShuffle(hash);
    }

    private static long mix(long current, long value) {
        return Long.rotateLeft(current + value * -4417276706812531889L, 31) * -7046029288634856825L;
    }

    private static long update(long hash, long value) {
        long temp = hash ^ XxHash64.mix(0L, value);
        return temp * -7046029288634856825L + -8796714831421723037L;
    }

    private static long updateTail(long hash, long value) {
        long temp = hash ^ XxHash64.mix(0L, value);
        return Long.rotateLeft(temp, 27) * -7046029288634856825L + -8796714831421723037L;
    }

    private static long updateTail(long hash, int value) {
        long unsigned = (long)value & 0xFFFFFFFFL;
        long temp = hash ^ unsigned * -7046029288634856825L;
        return Long.rotateLeft(temp, 23) * -4417276706812531889L + 1609587929392839161L;
    }

    private static long updateTail(long hash, byte value) {
        int unsigned = value & 0xFF;
        long temp = hash ^ (long)unsigned * 2870177450012600261L;
        return Long.rotateLeft(temp, 11) * -7046029288634856825L;
    }

    private static long finalShuffle(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }
}

