/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.BasicSliceOutput;
import io.airlift.slice.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public final class Slice
implements Comparable<Slice> {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(Slice.class);
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private static final VarHandle SHORT_HANDLE = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle FLOAT_HANDLE = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle DOUBLE_HANDLE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.LITTLE_ENDIAN);
    static final Slice EMPTY_SLICE = new Slice();
    private final byte[] base;
    private final int baseOffset;
    private final int size;
    private final long retainedSize;
    private int hash;

    private Slice() {
        this.base = new byte[0];
        this.baseOffset = 0;
        this.size = 0;
        this.retainedSize = INSTANCE_SIZE;
    }

    Slice(byte[] base) {
        Objects.requireNonNull(base, "base is null");
        if (base.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        this.base = base;
        this.baseOffset = 0;
        this.size = base.length;
        this.retainedSize = (long)INSTANCE_SIZE + SizeOf.sizeOf(base);
    }

    Slice(byte[] base, int offset, int length) {
        Objects.requireNonNull(base, "base is null");
        if (base.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        Objects.checkFromIndexSize(offset, length, base.length);
        this.base = base;
        this.baseOffset = offset;
        this.size = length;
        this.retainedSize = (long)INSTANCE_SIZE + SizeOf.sizeOf(base);
    }

    Slice(byte[] base, int baseOffset, int size, long retainedSize) {
        Objects.requireNonNull(base, "base is null");
        if (base.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        Objects.checkFromIndexSize(baseOffset, size, base.length);
        this.base = Objects.requireNonNull(base, "base is null");
        this.baseOffset = baseOffset;
        this.size = size;
        this.retainedSize = retainedSize;
    }

    public int length() {
        return this.size;
    }

    public long getRetainedSize() {
        return this.retainedSize;
    }

    public boolean isCompact() {
        return this.baseOffset == 0 && this.size == this.base.length;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] byteArray() {
        return this.base;
    }

    public int byteArrayOffset() {
        return this.baseOffset;
    }

    public void fill(byte value) {
        Arrays.fill(this.base, this.baseOffset, this.baseOffset + this.size, value);
    }

    public void clear() {
        this.clear(0, this.size);
    }

    public void clear(int offset, int length) {
        Arrays.fill(this.base, this.baseOffset, this.baseOffset + this.size, (byte)0);
    }

    public byte getByte(int index) {
        Objects.checkFromIndexSize(index, 1, this.length());
        return this.getByteUnchecked(index);
    }

    public byte getByteUnchecked(int index) {
        return this.base[this.baseOffset + index];
    }

    public short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    public short getShort(int index) {
        Objects.checkFromIndexSize(index, 2, this.length());
        return this.getShortUnchecked(index);
    }

    public short getShortUnchecked(int index) {
        return SHORT_HANDLE.get(this.base, this.baseOffset + index);
    }

    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    public int getInt(int index) {
        Objects.checkFromIndexSize(index, 4, this.length());
        return this.getIntUnchecked(index);
    }

    public int getIntUnchecked(int index) {
        return INT_HANDLE.get(this.base, this.baseOffset + index);
    }

    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    public long getLong(int index) {
        Objects.checkFromIndexSize(index, 8, this.length());
        return this.getLongUnchecked(index);
    }

    public long getLongUnchecked(int index) {
        return LONG_HANDLE.get(this.base, this.baseOffset + index);
    }

    public float getFloat(int index) {
        Objects.checkFromIndexSize(index, 4, this.length());
        return this.getFloatUnchecked(index);
    }

    public float getFloatUnchecked(int index) {
        return FLOAT_HANDLE.get(this.base, this.baseOffset + index);
    }

    public double getDouble(int index) {
        Objects.checkFromIndexSize(index, 8, this.length());
        return this.getDoubleUnchecked(index);
    }

    public double getDoubleUnchecked(int index) {
        return DOUBLE_HANDLE.get(this.base, this.baseOffset + index);
    }

    public void getBytes(int index, Slice destination) {
        this.getBytes(index, destination, 0, destination.length());
    }

    public void getBytes(int index, Slice destination, int destinationIndex, int length) {
        Objects.checkFromIndexSize(destinationIndex, length, destination.length());
        Objects.checkFromIndexSize(index, length, this.length());
        System.arraycopy(this.base, this.baseOffset + index, destination.base, destination.baseOffset + destinationIndex, length);
    }

    public void getBytes(int index, byte[] destination) {
        this.getBytes(index, destination, 0, destination.length);
    }

    public void getBytes(int index, byte[] destination, int destinationIndex, int length) {
        Objects.checkFromIndexSize(index, length, this.length());
        Objects.checkFromIndexSize(destinationIndex, length, destination.length);
        System.arraycopy(this.base, this.baseOffset + index, destination, destinationIndex, length);
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.length());
    }

    public byte[] getBytes(int index, int length) {
        byte[] bytes = new byte[length];
        this.getBytes(index, bytes, 0, length);
        return bytes;
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        Objects.checkFromIndexSize(index, length, this.length());
        out.write(this.byteArray(), this.byteArrayOffset() + index, length);
    }

    public short[] getShorts(int index, int length) {
        short[] shorts = new short[length];
        this.getShorts(index, shorts, 0, length);
        return shorts;
    }

    public void getShorts(int index, short[] destination) {
        this.getShorts(index, destination, 0, destination.length);
    }

    public void getShorts(int index, short[] destination, int destinationIndex, int length) {
        Objects.checkFromIndexSize(index, length * 2, this.length());
        Objects.checkFromIndexSize(destinationIndex, length, destination.length);
        MemorySegment segment = MemorySegment.ofArray(this.base);
        MemorySegment.copy(segment, ValueLayout.JAVA_SHORT_UNALIGNED, this.baseOffset + index, destination, destinationIndex, length);
    }

    public int[] getInts(int index, int length) {
        int[] ints = new int[length];
        this.getInts(index, ints, 0, length);
        return ints;
    }

    public void getInts(int index, int[] destination) {
        this.getInts(index, destination, 0, destination.length);
    }

    public void getInts(int index, int[] destination, int destinationIndex, int length) {
        Objects.checkFromIndexSize(index, length * 4, this.length());
        Objects.checkFromIndexSize(destinationIndex, length, destination.length);
        MemorySegment segment = MemorySegment.ofArray(this.base);
        MemorySegment.copy(segment, ValueLayout.JAVA_INT_UNALIGNED, this.baseOffset + index, destination, destinationIndex, length);
    }

    public long[] getLongs(int index, int length) {
        long[] longs = new long[length];
        this.getLongs(index, longs, 0, length);
        return longs;
    }

    public void getLongs(int index, long[] destination) {
        this.getLongs(index, destination, 0, destination.length);
    }

    public void getLongs(int index, long[] destination, int destinationIndex, int length) {
        Objects.checkFromIndexSize(index, length * 8, this.length());
        Objects.checkFromIndexSize(destinationIndex, length, destination.length);
        MemorySegment segment = MemorySegment.ofArray(this.base);
        MemorySegment.copy(segment, ValueLayout.JAVA_LONG_UNALIGNED, this.baseOffset + index, destination, destinationIndex, length);
    }

    public float[] getFloats(int index, int length) {
        float[] floats = new float[length];
        this.getFloats(index, floats, 0, length);
        return floats;
    }

    public void getFloats(int index, float[] destination) {
        this.getFloats(index, destination, 0, destination.length);
    }

    public void getFloats(int index, float[] destination, int destinationIndex, int length) {
        Objects.checkFromIndexSize(index, length * 4, this.length());
        Objects.checkFromIndexSize(destinationIndex, length, destination.length);
        MemorySegment segment = MemorySegment.ofArray(this.base);
        MemorySegment.copy(segment, ValueLayout.JAVA_FLOAT_UNALIGNED, this.baseOffset + index, destination, destinationIndex, length);
    }

    public double[] getDoubles(int index, int length) {
        double[] doubles = new double[length];
        this.getDoubles(index, doubles, 0, length);
        return doubles;
    }

    public void getDoubles(int index, double[] destination) {
        this.getDoubles(index, destination, 0, destination.length);
    }

    public void getDoubles(int index, double[] destination, int destinationIndex, int length) {
        Objects.checkFromIndexSize(index, length * 8, this.length());
        Objects.checkFromIndexSize(destinationIndex, length, destination.length);
        MemorySegment segment = MemorySegment.ofArray(this.base);
        MemorySegment.copy(segment, ValueLayout.JAVA_DOUBLE_UNALIGNED, this.baseOffset + index, destination, destinationIndex, length);
    }

    public void setByte(int index, int value) {
        Objects.checkFromIndexSize(index, 1, this.length());
        this.setByteUnchecked(index, value);
    }

    void setByteUnchecked(int index, int value) {
        this.base[this.baseOffset + index] = (byte)(value & 0xFF);
    }

    public void setShort(int index, int value) {
        Objects.checkFromIndexSize(index, 2, this.length());
        this.setShortUnchecked(index, value);
    }

    void setShortUnchecked(int index, int value) {
        SHORT_HANDLE.set(this.base, this.baseOffset + index, (short)(value & 0xFFFF));
    }

    public void setInt(int index, int value) {
        Objects.checkFromIndexSize(index, 4, this.length());
        this.setIntUnchecked(index, value);
    }

    void setIntUnchecked(int index, int value) {
        INT_HANDLE.set(this.base, this.baseOffset + index, value);
    }

    public void setLong(int index, long value) {
        Objects.checkFromIndexSize(index, 8, this.length());
        this.setLongUnchecked(index, value);
    }

    void setLongUnchecked(int index, long value) {
        LONG_HANDLE.set(this.base, this.baseOffset + index, value);
    }

    public void setFloat(int index, float value) {
        Objects.checkFromIndexSize(index, 4, this.length());
        FLOAT_HANDLE.set(this.base, this.baseOffset + index, value);
    }

    public void setDouble(int index, double value) {
        Objects.checkFromIndexSize(index, 8, this.length());
        DOUBLE_HANDLE.set(this.base, this.baseOffset + index, value);
    }

    public void setBytes(int index, Slice source) {
        this.setBytes(index, source, 0, source.length());
    }

    public void setBytes(int index, Slice source, int sourceIndex, int length) {
        Objects.checkFromIndexSize(index, length, this.length());
        Objects.checkFromIndexSize(sourceIndex, length, source.length());
        System.arraycopy(source.base, source.baseOffset + sourceIndex, this.base, this.baseOffset + index, length);
    }

    public void setBytes(int index, byte[] source) {
        this.setBytes(index, source, 0, source.length);
    }

    public void setBytes(int index, byte[] source, int sourceIndex, int length) {
        Objects.checkFromIndexSize(index, length, this.length());
        Objects.checkFromIndexSize(sourceIndex, length, source.length);
        System.arraycopy(source, sourceIndex, this.base, this.baseOffset + index, length);
    }

    public void setBytes(int index, InputStream in, int length) throws IOException {
        Objects.checkFromIndexSize(index, length, this.length());
        byte[] bytes = this.byteArray();
        int offset = this.byteArrayOffset() + index;
        while (length > 0) {
            int bytesRead = in.read(bytes, offset, length);
            if (bytesRead < 0) {
                throw new IndexOutOfBoundsException("End of stream");
            }
            length -= bytesRead;
            offset += bytesRead;
        }
    }

    public void setShorts(int index, short[] source) {
        this.setShorts(index, source, 0, source.length);
    }

    public void setShorts(int index, short[] source, int sourceIndex, int length) {
        Objects.checkFromIndexSize(index, length, this.length());
        Objects.checkFromIndexSize(sourceIndex, length, source.length);
        MemorySegment segment = MemorySegment.ofArray(this.base);
        MemorySegment.copy(source, sourceIndex, segment, ValueLayout.JAVA_SHORT_UNALIGNED, (long)(this.baseOffset + index), length);
    }

    public void setInts(int index, int[] source) {
        this.setInts(index, source, 0, source.length);
    }

    public void setInts(int index, int[] source, int sourceIndex, int length) {
        Objects.checkFromIndexSize(index, length, this.length());
        Objects.checkFromIndexSize(sourceIndex, length, source.length);
        MemorySegment segment = MemorySegment.ofArray(this.base);
        MemorySegment.copy(source, sourceIndex, segment, ValueLayout.JAVA_INT_UNALIGNED, (long)(this.baseOffset + index), length);
    }

    public void setLongs(int index, long[] source) {
        this.setLongs(index, source, 0, source.length);
    }

    public void setLongs(int index, long[] source, int sourceIndex, int length) {
        Objects.checkFromIndexSize(index, length, this.length());
        Objects.checkFromIndexSize(sourceIndex, length, source.length);
        MemorySegment segment = MemorySegment.ofArray(this.base);
        MemorySegment.copy(source, sourceIndex, segment, ValueLayout.JAVA_LONG_UNALIGNED, (long)(this.baseOffset + index), length);
    }

    public void setFloats(int index, float[] source) {
        this.setFloats(index, source, 0, source.length);
    }

    public void setFloats(int index, float[] source, int sourceIndex, int length) {
        Objects.checkFromIndexSize(index, length, this.length());
        Objects.checkFromIndexSize(sourceIndex, length, source.length);
        MemorySegment segment = MemorySegment.ofArray(this.base);
        MemorySegment.copy(source, sourceIndex, segment, ValueLayout.JAVA_FLOAT_UNALIGNED, (long)(this.baseOffset + index), length);
    }

    public void setDoubles(int index, double[] source) {
        this.setDoubles(index, source, 0, source.length);
    }

    public void setDoubles(int index, double[] source, int sourceIndex, int length) {
        Objects.checkFromIndexSize(index, length, this.length());
        Objects.checkFromIndexSize(sourceIndex, length, source.length);
        MemorySegment segment = MemorySegment.ofArray(this.base);
        MemorySegment.copy(source, sourceIndex, segment, ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)(this.baseOffset + index), length);
    }

    public Slice slice(int index, int length) {
        if (index == 0 && length == this.length()) {
            return this;
        }
        Objects.checkFromIndexSize(index, length, this.length());
        if (length == 0) {
            return Slices.EMPTY_SLICE;
        }
        return new Slice(this.base, this.baseOffset + index, length, this.retainedSize);
    }

    public Slice copy() {
        if (this.size == 0) {
            return Slices.EMPTY_SLICE;
        }
        return new Slice(Arrays.copyOfRange(this.base, this.baseOffset, this.baseOffset + this.size));
    }

    public Slice copy(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.size);
        if (length == 0) {
            return Slices.EMPTY_SLICE;
        }
        return new Slice(Arrays.copyOfRange(this.base, this.baseOffset + index, this.baseOffset + index + length));
    }

    public int indexOfByte(int b) {
        Preconditions.checkArgument(b >> 8 == 0, "byte value out of range");
        return this.indexOfByte((byte)b);
    }

    public int indexOfByte(byte b) {
        for (int i = 0; i < this.size; ++i) {
            if (this.getByteUnchecked(i) != b) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Slice slice) {
        return this.indexOf(slice, 0);
    }

    public int indexOf(Slice pattern, int offset) {
        if (this.size == 0 || offset >= this.size || offset < 0) {
            return -1;
        }
        if (pattern.length() == 0) {
            return offset;
        }
        if (pattern.length() < 4 || this.size < 8) {
            return this.indexOfBruteForce(pattern, offset);
        }
        int head = pattern.getIntUnchecked(0);
        int firstByteMask = head & 0xFF;
        firstByteMask |= firstByteMask << 8;
        firstByteMask |= firstByteMask << 16;
        int lastValidIndex = this.size - pattern.length();
        int index = offset;
        while (index <= lastValidIndex) {
            int value = this.getIntUnchecked(index);
            int valueXor = value ^ firstByteMask;
            int hasZeroBytes = valueXor - 0x1010101 & ~valueXor & 0x80808080;
            if (hasZeroBytes == 0) {
                index += 4;
                continue;
            }
            if (value == head && this.equalsUnchecked(index, pattern, 0, pattern.length())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    int indexOfBruteForce(Slice pattern, int offset) {
        if (this.size == 0 || offset >= this.size || offset < 0) {
            return -1;
        }
        if (pattern.length() == 0) {
            return offset;
        }
        byte firstByte = pattern.getByteUnchecked(0);
        int lastValidIndex = this.size - pattern.length();
        int index = offset;
        while (true) {
            if (index < lastValidIndex && this.getByteUnchecked(index) != firstByte) {
                ++index;
                continue;
            }
            if (index > lastValidIndex) break;
            if (this.equalsUnchecked(index, pattern, 0, pattern.length())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int compareTo(Slice that) {
        if (this == that) {
            return 0;
        }
        return this.compareTo(0, this.size, that, 0, that.size);
    }

    public int compareTo(int offset, int length, Slice that, int otherOffset, int otherLength) {
        if (this == that && offset == otherOffset && length == otherLength) {
            return 0;
        }
        Objects.checkFromIndexSize(offset, length, this.length());
        Objects.checkFromIndexSize(otherOffset, otherLength, that.length());
        return Arrays.compareUnsigned(this.base, this.baseOffset + offset, this.baseOffset + offset + length, that.base, that.baseOffset + otherOffset, that.baseOffset + otherOffset + otherLength);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice that = (Slice)o;
        if (this.length() != that.length()) {
            return false;
        }
        return this.equalsUnchecked(0, that, 0, this.length());
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.hashCode(0, this.size);
        return this.hash;
    }

    public int hashCode(int offset, int length) {
        return (int)XxHash64.hash(this, offset, length);
    }

    public boolean equals(int offset, int length, Slice that, int otherOffset, int otherLength) {
        if (length != otherLength) {
            return false;
        }
        if (this == that && offset == otherOffset) {
            return true;
        }
        Objects.checkFromIndexSize(offset, length, this.length());
        Objects.checkFromIndexSize(otherOffset, otherLength, that.length());
        return this.equalsUnchecked(offset, that, otherOffset, length);
    }

    boolean equalsUnchecked(int offset, Slice that, int otherOffset, int length) {
        return Arrays.equals(this.base, this.baseOffset + offset, this.baseOffset + offset + length, that.base, that.baseOffset + otherOffset, that.baseOffset + otherOffset + length);
    }

    public BasicSliceInput getInput() {
        return new BasicSliceInput(this);
    }

    public SliceOutput getOutput() {
        return new BasicSliceOutput(this);
    }

    public String toString(Charset charset) {
        return this.toString(0, this.length(), charset);
    }

    public String toStringUtf8() {
        return this.toString(StandardCharsets.UTF_8);
    }

    public String toStringAscii() {
        return this.toStringAscii(0, this.size);
    }

    public String toStringAscii(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.length());
        if (length == 0) {
            return "";
        }
        return new String(this.byteArray(), this.byteArrayOffset() + index, length, StandardCharsets.US_ASCII);
    }

    public String toString(int index, int length, Charset charset) {
        if (length == 0) {
            return "";
        }
        return new String(this.byteArray(), this.byteArrayOffset() + index, length, charset);
    }

    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(0, this.size);
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.length());
        if (this.length() == 0) {
            return EMPTY_BYTE_BUFFER;
        }
        return ByteBuffer.wrap(this.byteArray(), this.byteArrayOffset() + index, length).slice();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Slice{");
        builder.append("base=").append(Slice.identityToString(this.base)).append(", ");
        builder.append("baseOffset=").append(this.baseOffset);
        builder.append(", length=").append(this.length());
        builder.append('}');
        return builder.toString();
    }

    private static String identityToString(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }
}

