/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.function.ToLongFunction;

public final class SizeOf {
    public static final byte SIZE_OF_BYTE = 1;
    public static final byte SIZE_OF_SHORT = 2;
    public static final byte SIZE_OF_INT = 4;
    public static final byte SIZE_OF_LONG = 8;
    public static final byte SIZE_OF_FLOAT = 4;
    public static final byte SIZE_OF_DOUBLE = 8;
    private static final int OBJECT_HEADER_SIZE;
    private static final int ARRAY_HEADER_SIZE;
    private static final int REFERENCE_SIZE;
    private static final int OBJECT_ALIGNMENT;
    public static final int BOOLEAN_INSTANCE_SIZE;
    public static final int BYTE_INSTANCE_SIZE;
    public static final int SHORT_INSTANCE_SIZE;
    public static final int CHARACTER_INSTANCE_SIZE;
    public static final int INTEGER_INSTANCE_SIZE;
    public static final int LONG_INSTANCE_SIZE;
    public static final int FLOAT_INSTANCE_SIZE;
    public static final int DOUBLE_INSTANCE_SIZE;
    public static final int OPTIONAL_INSTANCE_SIZE;
    public static final int OPTIONAL_INT_INSTANCE_SIZE;
    public static final int OPTIONAL_LONG_INSTANCE_SIZE;
    public static final int OPTIONAL_DOUBLE_INSTANCE_SIZE;
    public static final int STRING_INSTANCE_SIZE;
    private static final int SIMPLE_ENTRY_INSTANCE_SIZE;

    private SizeOf() {
    }

    private static boolean getBooleanVmOption(HotSpotDiagnosticMXBean bean, String option, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(bean.getVMOption(option).getValue());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    private static int getIntVmOption(HotSpotDiagnosticMXBean bean, String option, int defaultValue) {
        try {
            return Integer.parseInt(bean.getVMOption(option).getValue());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static long sizeOf(boolean[] array) {
        return array == null ? 0L : SizeOf.sizeOfBooleanArray(array.length);
    }

    public static long sizeOf(byte[] array) {
        return array == null ? 0L : SizeOf.sizeOfByteArray(array.length);
    }

    public static long sizeOf(short[] array) {
        return array == null ? 0L : SizeOf.sizeOfShortArray(array.length);
    }

    public static long sizeOf(char[] array) {
        return array == null ? 0L : SizeOf.sizeOfCharArray(array.length);
    }

    public static long sizeOf(int[] array) {
        return array == null ? 0L : SizeOf.sizeOfIntArray(array.length);
    }

    public static long sizeOf(long[] array) {
        return array == null ? 0L : SizeOf.sizeOfLongArray(array.length);
    }

    public static long sizeOf(float[] array) {
        return array == null ? 0L : SizeOf.sizeOfFloatArray(array.length);
    }

    public static long sizeOf(double[] array) {
        return array == null ? 0L : SizeOf.sizeOfDoubleArray(array.length);
    }

    public static long sizeOf(Object[] array) {
        return array == null ? 0L : SizeOf.sizeOfObjectArray(array.length);
    }

    public static long sizeOf(Boolean value) {
        return value == null ? 0L : (long)BOOLEAN_INSTANCE_SIZE;
    }

    public static long sizeOf(Byte value) {
        return value == null ? 0L : (long)BYTE_INSTANCE_SIZE;
    }

    public static long sizeOf(Short value) {
        return value == null ? 0L : (long)SHORT_INSTANCE_SIZE;
    }

    public static long sizeOf(Character value) {
        return value == null ? 0L : (long)CHARACTER_INSTANCE_SIZE;
    }

    public static long sizeOf(Integer value) {
        return value == null ? 0L : (long)INTEGER_INSTANCE_SIZE;
    }

    public static long sizeOf(Long value) {
        return value == null ? 0L : (long)LONG_INSTANCE_SIZE;
    }

    public static long sizeOf(Float value) {
        return value == null ? 0L : (long)FLOAT_INSTANCE_SIZE;
    }

    public static long sizeOf(Double value) {
        return value == null ? 0L : (long)DOUBLE_INSTANCE_SIZE;
    }

    public static <T> long sizeOf(Optional<T> optional, ToLongFunction<T> valueSize) {
        return optional != null && optional.isPresent() ? (long)OPTIONAL_INSTANCE_SIZE + valueSize.applyAsLong(optional.get()) : 0L;
    }

    public static long sizeOf(OptionalInt optional) {
        return optional != null && optional.isPresent() ? (long)OPTIONAL_INT_INSTANCE_SIZE : 0L;
    }

    public static long sizeOf(OptionalLong optional) {
        return optional != null && optional.isPresent() ? (long)OPTIONAL_LONG_INSTANCE_SIZE : 0L;
    }

    public static long sizeOf(OptionalDouble optional) {
        return optional != null && optional.isPresent() ? (long)OPTIONAL_DOUBLE_INSTANCE_SIZE : 0L;
    }

    public static long estimatedSizeOf(String string) {
        return string == null ? 0L : (long)(STRING_INSTANCE_SIZE + string.length() * 2);
    }

    public static <T> long estimatedSizeOf(List<T> list, ToLongFunction<T> valueSize) {
        if (list == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(list.size());
        for (T value : list) {
            result += valueSize.applyAsLong(value);
        }
        return result;
    }

    public static <T> long estimatedSizeOf(Queue<T> queue, ToLongFunction<T> valueSize) {
        if (queue == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(queue.size());
        for (Object value : queue) {
            result += valueSize.applyAsLong(value);
        }
        return result;
    }

    public static <T> long estimatedSizeOf(Set<T> set, ToLongFunction<T> valueSize) {
        if (set == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(set.size());
        for (T value : set) {
            result += (long)SIMPLE_ENTRY_INSTANCE_SIZE + valueSize.applyAsLong(value);
        }
        return result;
    }

    public static <K, V> long estimatedSizeOf(Map<K, V> map, ToLongFunction<K> keySize, ToLongFunction<V> valueSize) {
        if (map == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result += (long)SIMPLE_ENTRY_INSTANCE_SIZE + keySize.applyAsLong(entry.getKey()) + valueSize.applyAsLong(entry.getValue());
        }
        return result;
    }

    public static <K, V> long estimatedSizeOf(Map<K, V> map, long keySize, long valueSize) {
        if (map == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(map.size());
        return result += (long)map.size() * ((long)SIMPLE_ENTRY_INSTANCE_SIZE + keySize + valueSize);
    }

    public static long sizeOfBooleanArray(int length) {
        return SizeOf.alignSize((long)ARRAY_HEADER_SIZE + (long)length);
    }

    public static long sizeOfByteArray(int length) {
        return SizeOf.alignSize((long)ARRAY_HEADER_SIZE + (long)length);
    }

    public static long sizeOfShortArray(int length) {
        return SizeOf.alignSize((long)ARRAY_HEADER_SIZE + 2L * (long)length);
    }

    public static long sizeOfCharArray(int length) {
        return SizeOf.alignSize((long)ARRAY_HEADER_SIZE + 2L * (long)length);
    }

    public static long sizeOfIntArray(int length) {
        return SizeOf.alignSize((long)ARRAY_HEADER_SIZE + 4L * (long)length);
    }

    public static long sizeOfLongArray(int length) {
        return SizeOf.alignSize((long)ARRAY_HEADER_SIZE + 8L * (long)length);
    }

    public static long sizeOfFloatArray(int length) {
        return SizeOf.alignSize((long)ARRAY_HEADER_SIZE + 4L * (long)length);
    }

    public static long sizeOfDoubleArray(int length) {
        return SizeOf.alignSize((long)ARRAY_HEADER_SIZE + 8L * (long)length);
    }

    public static long sizeOfObjectArray(int length) {
        return SizeOf.alignSize((long)ARRAY_HEADER_SIZE + (long)REFERENCE_SIZE * (long)length);
    }

    public static int instanceSize(Class<?> clazz) {
        long size = OBJECT_HEADER_SIZE;
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                size += (long)SizeOf.sizeOfField(field.getType());
            }
        }
        return Math.toIntExact(SizeOf.alignSize(size));
    }

    private static int sizeOfField(Class<?> type) {
        if (type == Boolean.TYPE || type == Byte.TYPE) {
            return 1;
        }
        if (type == Short.TYPE || type == Character.TYPE) {
            return 2;
        }
        if (type == Integer.TYPE || type == Float.TYPE) {
            return 4;
        }
        if (type == Long.TYPE || type == Double.TYPE) {
            return 8;
        }
        return REFERENCE_SIZE;
    }

    private static long alignSize(long size) {
        return Math.ceilDiv(size, OBJECT_ALIGNMENT) * (long)OBJECT_ALIGNMENT;
    }

    static {
        boolean compressedClassPointers;
        HotSpotDiagnosticMXBean hotSpotBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
        boolean compressedOops = SizeOf.getBooleanVmOption(hotSpotBean, "UseCompressedOops", true);
        REFERENCE_SIZE = compressedOops ? 4 : 8;
        OBJECT_ALIGNMENT = SizeOf.getIntVmOption(hotSpotBean, "ObjectAlignmentInBytes", 8);
        boolean compactHeaders = SizeOf.getBooleanVmOption(hotSpotBean, "UseCompactObjectHeaders", false);
        OBJECT_HEADER_SIZE = compactHeaders ? 8 : 8 + ((compressedClassPointers = SizeOf.getBooleanVmOption(hotSpotBean, "UseCompressedClassPointers", true)) ? 4 : 8);
        int rawArrayHeader = OBJECT_HEADER_SIZE + 4;
        ARRAY_HEADER_SIZE = (int)SizeOf.alignSize(rawArrayHeader);
        BOOLEAN_INSTANCE_SIZE = SizeOf.instanceSize(Boolean.class);
        BYTE_INSTANCE_SIZE = SizeOf.instanceSize(Byte.class);
        SHORT_INSTANCE_SIZE = SizeOf.instanceSize(Short.class);
        CHARACTER_INSTANCE_SIZE = SizeOf.instanceSize(Character.class);
        INTEGER_INSTANCE_SIZE = SizeOf.instanceSize(Integer.class);
        LONG_INSTANCE_SIZE = SizeOf.instanceSize(Long.class);
        FLOAT_INSTANCE_SIZE = SizeOf.instanceSize(Float.class);
        DOUBLE_INSTANCE_SIZE = SizeOf.instanceSize(Double.class);
        OPTIONAL_INSTANCE_SIZE = SizeOf.instanceSize(Optional.class);
        OPTIONAL_INT_INSTANCE_SIZE = SizeOf.instanceSize(OptionalInt.class);
        OPTIONAL_LONG_INSTANCE_SIZE = SizeOf.instanceSize(OptionalLong.class);
        OPTIONAL_DOUBLE_INSTANCE_SIZE = SizeOf.instanceSize(OptionalDouble.class);
        STRING_INSTANCE_SIZE = SizeOf.instanceSize(String.class);
        SIMPLE_ENTRY_INSTANCE_SIZE = SizeOf.instanceSize(AbstractMap.SimpleEntry.class);
    }
}

