/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceTooLargeException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class Slices {
    public static final Slice EMPTY_SLICE = new Slice();
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    static final int SLICE_ALLOC_THRESHOLD = 524288;
    static final double SLICE_ALLOW_SKEW = 1.25;

    private Slices() {
    }

    public static Slice ensureSize(Slice existingSlice, int minWritableBytes) {
        if (existingSlice == null) {
            return Slices.allocate(minWritableBytes);
        }
        if (minWritableBytes <= existingSlice.length()) {
            return existingSlice;
        }
        int newCapacity = existingSlice.length() == 0 ? 1 : existingSlice.length();
        while (newCapacity < minWritableBytes) {
            if (newCapacity < 524288) {
                newCapacity <<= 1;
                continue;
            }
            if ((newCapacity = (int)((double)newCapacity * 1.25)) <= 0x7FFFFFF7 || minWritableBytes > 0x7FFFFFF7) continue;
            newCapacity = 0x7FFFFFF7;
        }
        Slice newSlice = Slices.allocate(newCapacity);
        newSlice.setBytes(0, existingSlice, 0, existingSlice.length());
        return newSlice;
    }

    public static Slice allocate(int capacity) {
        if (capacity == 0) {
            return EMPTY_SLICE;
        }
        if (capacity > 0x7FFFFFF7) {
            throw new SliceTooLargeException(String.format("Cannot allocate slice larger than %s bytes", 0x7FFFFFF7));
        }
        return new Slice(new byte[capacity]);
    }

    public static Slice copyOf(Slice slice) {
        return Slices.copyOf(slice, 0, slice.length());
    }

    public static Slice copyOf(Slice slice, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, slice.length());
        Slice copy = Slices.allocate(length);
        copy.setBytes(0, slice, offset, length);
        return copy;
    }

    public static Slice wrappedHeapBuffer(ByteBuffer buffer) {
        if (!buffer.hasArray()) {
            throw new IllegalArgumentException("cannot wrap " + buffer.getClass().getName());
        }
        return new Slice(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
    }

    public static Slice wrappedBuffer(byte ... array) {
        if (array.length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array);
    }

    public static Slice wrappedBuffer(byte[] array, int offset, int length) {
        if (length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array, offset, length);
    }

    public static Slice copiedBuffer(String string, Charset charset) {
        Objects.requireNonNull(string, "string is null");
        Objects.requireNonNull(charset, "charset is null");
        return Slices.wrappedBuffer(string.getBytes(charset));
    }

    public static Slice utf8Slice(String string) {
        return Slices.copiedBuffer(string, StandardCharsets.UTF_8);
    }
}

