/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class DynamicSliceOutput
extends SliceOutput {
    private Slice slice;
    private int size;

    public DynamicSliceOutput(int estimatedSize) {
        this.slice = Slices.allocate(estimatedSize);
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isWritable() {
        return this.writableBytes() > 0;
    }

    @Override
    public int writableBytes() {
        return this.slice.length() - this.size;
    }

    @Override
    public void writeByte(int value) {
        this.slice = Slices.ensureSize(this.slice, this.size + 1);
        this.slice.setByte(this.size, value);
        ++this.size;
    }

    @Override
    public void writeShort(int value) {
        this.slice = Slices.ensureSize(this.slice, this.size + 2);
        this.slice.setShort(this.size, value);
        this.size += 2;
    }

    @Override
    public void writeInt(int value) {
        this.slice = Slices.ensureSize(this.slice, this.size + 4);
        this.slice.setInt(this.size, value);
        this.size += 4;
    }

    @Override
    public void writeLong(long value) {
        this.slice = Slices.ensureSize(this.slice, this.size + 8);
        this.slice.setLong(this.size, value);
        this.size += 8;
    }

    @Override
    public void writeDouble(double value) {
        this.slice = Slices.ensureSize(this.slice, this.size + 8);
        this.slice.setDouble(this.size, value);
        this.size += 8;
    }

    @Override
    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    @Override
    public void writeBytes(byte[] source, int sourceIndex, int length) {
        this.slice = Slices.ensureSize(this.slice, this.size + length);
        this.slice.setBytes(this.size, source, sourceIndex, length);
        this.size += length;
    }

    @Override
    public void writeBytes(Slice source) {
        this.writeBytes(source, 0, source.length());
    }

    @Override
    public void writeBytes(Slice source, int sourceIndex, int length) {
        this.slice = Slices.ensureSize(this.slice, this.size + length);
        this.slice.setBytes(this.size, source, sourceIndex, length);
        this.size += length;
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        this.slice = Slices.ensureSize(this.slice, this.size + length);
        int writtenBytes = this.slice.setBytes(this.size, in, length);
        if (writtenBytes > 0) {
            this.size += writtenBytes;
        }
        return writtenBytes;
    }

    @Override
    public void writeZero(int length) {
        this.slice = Slices.ensureSize(this.slice, this.size + length);
        super.writeZero(length);
    }

    @Override
    public DynamicSliceOutput appendLong(long value) {
        this.writeLong(value);
        return this;
    }

    @Override
    public DynamicSliceOutput appendDouble(double value) {
        this.writeDouble(value);
        return this;
    }

    @Override
    public DynamicSliceOutput appendInt(int value) {
        this.writeInt(value);
        return this;
    }

    @Override
    public DynamicSliceOutput appendShort(int value) {
        this.writeShort(value);
        return this;
    }

    @Override
    public DynamicSliceOutput appendByte(int value) {
        this.writeByte(value);
        return this;
    }

    @Override
    public DynamicSliceOutput appendBytes(byte[] source, int sourceIndex, int length) {
        this.write(source, sourceIndex, length);
        return this;
    }

    @Override
    public DynamicSliceOutput appendBytes(byte[] source) {
        this.writeBytes(source);
        return this;
    }

    @Override
    public DynamicSliceOutput appendBytes(Slice slice) {
        this.writeBytes(slice);
        return this;
    }

    @Override
    public Slice slice() {
        return this.slice.slice(0, this.size);
    }

    @Override
    public Slice getUnderlyingSlice() {
        return this.slice;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BasicSliceOutput{");
        builder.append("size=").append(this.size);
        builder.append(", capacity=").append(this.slice.length());
        builder.append('}');
        return builder.toString();
    }

    @Override
    public String toString(Charset charset) {
        return this.slice.toString(0, this.size, charset);
    }
}

