/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.common.primitives.Ints;
import io.airlift.slice.RuntimeIOException;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class OutputStreamSliceOutput
extends SliceOutput {
    private final CountingOutputStream countingOutputStream;
    private final LittleEndianDataOutputStream dataOutputStream;

    public OutputStreamSliceOutput(OutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream, (Object)"outputStream is null");
        this.countingOutputStream = new CountingOutputStream(outputStream);
        this.dataOutputStream = new LittleEndianDataOutputStream((OutputStream)this.countingOutputStream);
    }

    @Override
    public void flush() throws IOException {
        this.countingOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.countingOutputStream.close();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("OutputStream can not be reset");
    }

    @Override
    public int size() {
        return Ints.checkedCast((long)this.countingOutputStream.getCount());
    }

    @Override
    public int writableBytes() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void writeByte(int value) {
        try {
            this.dataOutputStream.writeByte(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeShort(int value) {
        try {
            this.dataOutputStream.writeShort(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeInt(int value) {
        try {
            this.dataOutputStream.writeInt(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeLong(long value) {
        try {
            this.dataOutputStream.writeLong(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeDouble(double value) {
        try {
            this.dataOutputStream.writeDouble(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeBytes(Slice source) {
        this.writeBytes(source, 0, source.length());
    }

    @Override
    public void writeBytes(Slice source, int sourceIndex, int length) {
        try {
            source.getBytes(sourceIndex, (OutputStream)this.dataOutputStream, length);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    @Override
    public void writeBytes(byte[] source, int sourceIndex, int length) {
        try {
            this.dataOutputStream.write(source, sourceIndex, length);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        int bytesRead;
        int newBytes;
        byte[] bytes = new byte[4096];
        for (bytesRead = 0; bytesRead < length && (newBytes = in.read(bytes)) >= 0; bytesRead += newBytes) {
            this.dataOutputStream.write(bytes, 0, Math.min(newBytes, length - bytesRead));
        }
        return bytesRead;
    }

    @Override
    public SliceOutput appendLong(long value) {
        this.writeLong(value);
        return this;
    }

    @Override
    public SliceOutput appendDouble(double value) {
        this.writeDouble(value);
        return this;
    }

    @Override
    public SliceOutput appendInt(int value) {
        this.writeInt(value);
        return this;
    }

    @Override
    public SliceOutput appendShort(int value) {
        this.writeShort(value);
        return this;
    }

    @Override
    public SliceOutput appendBytes(byte[] source, int sourceIndex, int length) {
        this.writeBytes(source, sourceIndex, length);
        return this;
    }

    @Override
    public SliceOutput appendBytes(byte[] source) {
        this.writeBytes(source);
        return this;
    }

    @Override
    public SliceOutput appendBytes(Slice slice) {
        this.writeBytes(slice);
        return this;
    }

    @Override
    public Slice slice() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Charset charset) {
        return this.toString();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("countingOutputStream", (Object)this.countingOutputStream).add("dataOutputStream", (Object)this.dataOutputStream).toString();
    }
}

