/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class SizeOf {
    public static final byte SIZE_OF_BYTE = 1;
    public static final byte SIZE_OF_SHORT = 2;
    public static final byte SIZE_OF_INT = 4;
    public static final byte SIZE_OF_LONG = 8;
    public static final byte SIZE_OF_FLOAT = 4;
    public static final byte SIZE_OF_DOUBLE = 8;
    private static final Unsafe UNSAFE;

    public static long sizeOf(boolean[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)Unsafe.ARRAY_BOOLEAN_BASE_OFFSET + (long)Unsafe.ARRAY_BOOLEAN_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(byte[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)Unsafe.ARRAY_BYTE_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(short[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)Unsafe.ARRAY_SHORT_BASE_OFFSET + (long)Unsafe.ARRAY_SHORT_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(int[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)Unsafe.ARRAY_INT_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(long[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)Unsafe.ARRAY_LONG_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(float[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)Unsafe.ARRAY_FLOAT_BASE_OFFSET + (long)Unsafe.ARRAY_FLOAT_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(double[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(Object[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE * (long)array.length;
    }

    private SizeOf() {
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
            if (UNSAFE == null) {
                throw new RuntimeException("Unsafe access not available");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

