/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.junit;

import io.airlift.junit.MissingAnnotationsException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstancePreConstructCallback;

public class ReportMissingTestAnnotation
implements TestInstancePreConstructCallback {
    public void preConstructTestInstance(TestInstanceFactoryContext factoryContext, ExtensionContext extensionContext) throws MissingAnnotationsException {
        ReportMissingTestAnnotation.reportMissingTestAnnotations(factoryContext.getTestClass());
    }

    static void reportMissingTestAnnotations(Class<?> testClass) throws MissingAnnotationsException {
        Class<?> current = testClass;
        HashSet<Failure> failures = new HashSet<Failure>();
        while (current.getSuperclass() != null) {
            List candidates = Arrays.stream(current.getDeclaredMethods()).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> !method.isBridge()).filter(method -> !method.isSynthetic()).filter(method -> !method.isAnnotationPresent(Test.class) && !method.isAnnotationPresent(RepeatedTest.class)).collect(Collectors.toList());
            for (Method candidate : candidates) {
                Optional<Method> annotatedBase = ReportMissingTestAnnotation.getOverridden(candidate).stream().filter(method -> method.isAnnotationPresent(Test.class) || method.isAnnotationPresent(RepeatedTest.class)).findFirst();
                annotatedBase.ifPresent(method -> failures.add(new Failure(candidate, (Method)method)));
            }
            current = current.getSuperclass();
        }
        if (!failures.isEmpty()) {
            throw new MissingAnnotationsException(testClass, failures);
        }
    }

    private static List<Method> getOverridden(Method method) {
        ArrayList<Method> result = new ArrayList<Method>();
        Class<?> clazz = method.getDeclaringClass();
        while (clazz.getSuperclass() != null) {
            try {
                result.add(clazz.getSuperclass().getDeclaredMethod(method.getName(), method.getParameterTypes()));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public record Failure(Method child, Method parent) {
    }
}

