/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server.testing;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpsConfig;
import io.airlift.http.server.ServerFeature;
import io.airlift.http.server.testing.ForTestingServer;
import io.airlift.node.NodeInfo;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.Set;

public class TestingHttpServer
extends HttpServer {
    private final HttpServerInfo httpServerInfo;

    public TestingHttpServer(String name, HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Servlet servlet) throws IOException {
        this(name, httpServerInfo, nodeInfo, config, servlet, ServerFeature.builder().build());
    }

    public TestingHttpServer(String name, HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Servlet servlet, Set<ServerFeature> serverFeatures) throws IOException {
        this(name, httpServerInfo, nodeInfo, config, Optional.empty(), servlet, (Set<Filter>)ImmutableSet.of(), (Set<HttpServerBinder.HttpResourceBinding>)ImmutableSet.of(), serverFeatures, HttpServer.ClientCertificate.NONE);
    }

    @Inject
    public TestingHttpServer(@ForTestingServer String name, HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Optional<HttpsConfig> httpsConfig, Servlet servlet, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, Set<ServerFeature> serverFeatures, HttpServer.ClientCertificate clientCertificate) throws IOException {
        super(name, httpServerInfo, nodeInfo, config.setLogEnabled(false), httpsConfig, servlet, (Set<Filter>)ImmutableSet.copyOf(filters), (Set<HttpServerBinder.HttpResourceBinding>)ImmutableSet.copyOf(resources), serverFeatures, clientCertificate, Optional.empty(), Optional.empty());
        this.httpServerInfo = httpServerInfo;
    }

    public URI getBaseUrl() {
        return this.httpServerInfo.getHttpUri();
    }

    public int getPort() {
        return this.httpServerInfo.getHttpUri().getPort();
    }

    public HttpServerInfo getHttpServerInfo() {
        return this.httpServerInfo;
    }
}

