/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import io.airlift.http.server.BinderUtils;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpsConfig;
import io.airlift.http.server.ServerFeature;
import io.airlift.node.NodeInfo;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.management.MBeanServer;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpServerProvider
implements Provider<HttpServer> {
    private final String name;
    private final Optional<Class<? extends Annotation>> qualifier;
    private Injector injector;
    private Optional<MBeanServer> mbeanServer = Optional.empty();

    public HttpServerProvider(String name, Optional<Class<? extends Annotation>> qualifier) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.qualifier = Objects.requireNonNull(qualifier, "qualifier is null");
    }

    @Inject(optional=true)
    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = Optional.of(Objects.requireNonNull(mBeanServer, "mBeanServer is null"));
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = Objects.requireNonNull(injector, "injector is null");
    }

    public HttpServer get() {
        try {
            HttpServer httpServer = new HttpServer(this.name, (HttpServerInfo)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, HttpServerInfo.class)), (NodeInfo)this.injector.getInstance(NodeInfo.class), (HttpServerConfig)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, HttpServerConfig.class)), (Optional)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, new TypeLiteral<Optional<HttpsConfig>>(this){})), (Servlet)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, Servlet.class)), (Set)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, new TypeLiteral<Set<Filter>>(this){})), (Set)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, new TypeLiteral<Set<HttpServerBinder.HttpResourceBinding>>(this){})), (Set)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, new TypeLiteral<Set<ServerFeature>>(this){})), (HttpServer.ClientCertificate)((Object)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, HttpServer.ClientCertificate.class))), this.mbeanServer, (Optional)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, new TypeLiteral<Optional<SslContextFactory.Server>>(this){})));
            httpServer.start();
            return httpServer;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

