/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.AnnouncementHttpServerInfo;
import io.airlift.http.server.AnnouncementHttpServerInfoProvider;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpServerInfoProvider;
import io.airlift.http.server.HttpServerProvider;
import io.airlift.http.server.HttpsConfig;
import io.airlift.http.server.ServerFeature;
import io.airlift.http.server.tracing.TracingServletFilter;
import jakarta.annotation.Nullable;
import jakarta.servlet.Filter;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.weakref.jmx.guice.ExportBinder;

public class HttpServerModule
extends AbstractConfigurationAwareModule {
    private final String name;
    private final Optional<Class<? extends Annotation>> qualifier;
    @Nullable
    private final String configPrefix;

    public HttpServerModule(String name, Optional<Class<? extends Annotation>> qualifier, @Nullable String configPrefix) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.qualifier = Objects.requireNonNull(qualifier, "qualifier is null");
        this.configPrefix = configPrefix;
        if (this.qualifier.isPresent()) {
            Preconditions.checkArgument((this.configPrefix != null ? 1 : 0) != 0, (Object)"qualifier is present but configPrefix is null");
        }
    }

    public HttpServerModule(String name, Class<? extends Annotation> qualifier, @Nullable String configPrefix) {
        this(name, Optional.of(Objects.requireNonNull(qualifier, "qualifier is null")), configPrefix);
    }

    public HttpServerModule() {
        this("http-server", Optional.empty(), null);
    }

    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(this.qualifiedKey(HttpServer.class)).toProvider((Provider)new HttpServerProvider(this.name, this.qualifier)).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, this.qualifiedKey(HttpServer.ClientCertificate.class)).setDefault().toInstance((Object)HttpServer.ClientCertificate.NONE);
        ExportBinder.newExporter((Binder)binder).export(this.qualifiedKey(HttpServer.class)).withGeneratedName();
        Multibinder.newSetBinder((Binder)binder, this.qualifiedKey(ServerFeature.class));
        Multibinder.newSetBinder((Binder)binder, this.qualifiedKey(Filter.class)).addBinding().to(TracingServletFilter.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, this.qualifiedKey(HttpServerBinder.HttpResourceBinding.class));
        OptionalBinder.newOptionalBinder((Binder)binder, this.qualifiedKey(SslContextFactory.Server.class));
        ConfigBinder.configBinder((Binder)binder).bindConfig(this.qualifiedKey(HttpServerConfig.class), HttpServerConfig.class, this.configPrefix);
        OptionalBinder.newOptionalBinder((Binder)binder, this.qualifiedKey(HttpsConfig.class));
        binder.bind(this.qualifiedKey(AnnouncementHttpServerInfo.class)).toProvider((Provider)new AnnouncementHttpServerInfoProvider(this.qualifier)).in(Scopes.SINGLETON);
        binder.bind(this.qualifiedKey(HttpServerInfo.class)).toProvider((Provider)new HttpServerInfoProvider(this.qualifier)).in(Scopes.SINGLETON);
        this.install(ConditionalModule.conditionalModule(this.qualifiedKey(HttpServerConfig.class), HttpServerConfig.class, (String)this.configPrefix, HttpServerConfig::isHttpsEnabled, moduleBinder -> ConfigBinder.configBinder((Binder)moduleBinder).bindConfig(this.qualifiedKey(HttpsConfig.class), HttpsConfig.class, this.configPrefix)));
        ConfigBinder.configBinder((Binder)binder).bindConfig(this.qualifiedKey(HttpServerConfig.class), HttpServerConfig.class, this.configPrefix);
    }

    private <T> Key<T> qualifiedKey(Class<T> type) {
        return this.qualifier.map(annotation -> Key.get((Class)type, (Class)annotation)).orElseGet(() -> Key.get((Class)type));
    }
}

