/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import io.airlift.http.server.BinderUtils;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpsConfig;
import io.airlift.node.NodeInfo;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;

public class HttpServerInfoProvider
implements Provider<HttpServerInfo> {
    private final Optional<Class<? extends Annotation>> qualifier;
    private Injector injector;

    public HttpServerInfoProvider(Optional<Class<? extends Annotation>> qualifier) {
        this.qualifier = Objects.requireNonNull(qualifier, "qualifier is null");
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = Objects.requireNonNull(injector, "injector is null");
    }

    public HttpServerInfo get() {
        HttpServerConfig httpConfig = (HttpServerConfig)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, HttpServerConfig.class));
        Optional httpsConfig = (Optional)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, new TypeLiteral<Optional<HttpsConfig>>(this){}));
        NodeInfo nodeConfig = (NodeInfo)this.injector.getInstance(NodeInfo.class);
        return new HttpServerInfo(httpConfig, httpsConfig, nodeConfig);
    }
}

