/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.http.server.BinderUtils;
import io.airlift.http.server.ServerFeature;
import jakarta.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HttpServerBinder {
    private final Binder binder;
    private final Multibinder<ServerFeature> features;
    private final Optional<Class<? extends Annotation>> qualifier;

    private HttpServerBinder(Binder binder, @Nullable Class<? extends Annotation> qualifier) {
        Objects.requireNonNull(binder, "binder is null");
        this.binder = binder.skipSources(new Class[]{this.getClass()});
        this.qualifier = Optional.ofNullable(qualifier);
        this.features = Multibinder.newSetBinder((Binder)binder, BinderUtils.qualifiedKey(this.qualifier, ServerFeature.class));
    }

    public static HttpServerBinder httpServerBinder(Binder binder) {
        return new HttpServerBinder(binder, null);
    }

    public static HttpServerBinder httpServerBinder(Binder binder, Class<? extends Annotation> qualifier) {
        Objects.requireNonNull(qualifier, "qualifier is null");
        return new HttpServerBinder(binder, qualifier);
    }

    @Deprecated
    public HttpServerBinder enableVirtualThreads() {
        return this.withFeature(ServerFeature.VIRTUAL_THREADS);
    }

    @Deprecated
    public HttpServerBinder enableCaseSensitiveHeaderCache() {
        return this.withFeature(ServerFeature.CASE_SENSITIVE_HEADER_CACHE);
    }

    @Deprecated
    public HttpServerBinder enableLegacyUriCompliance() {
        return this.withFeature(ServerFeature.LEGACY_URI_COMPLIANCE);
    }

    public HttpServerBinder withFeature(ServerFeature serverFeature) {
        this.features.addBinding().toInstance((Object)serverFeature);
        return this;
    }

    public HttpServerBinder withFeatures(Set<ServerFeature> serverFeatures) {
        serverFeatures.forEach(this::withFeature);
        return this;
    }

    public HttpResourceBinding bindResource(String baseUri, String classPathResourceBase) {
        HttpResourceBinding httpResourceBinding = new HttpResourceBinding(baseUri, classPathResourceBase);
        Multibinder.newSetBinder((Binder)this.binder, BinderUtils.qualifiedKey(this.qualifier, HttpResourceBinding.class)).addBinding().toInstance((Object)httpResourceBinding);
        return httpResourceBinding;
    }

    public static class HttpResourceBinding {
        private final String baseUri;
        private final String classPathResourceBase;
        private final List<String> welcomeFiles = new ArrayList<String>();

        public HttpResourceBinding(String baseUri, String classPathResourceBase) {
            this.baseUri = baseUri;
            this.classPathResourceBase = classPathResourceBase;
        }

        public String getBaseUri() {
            return this.baseUri;
        }

        public String getClassPathResourceBase() {
            return this.classPathResourceBase;
        }

        public List<String> getWelcomeFiles() {
            return ImmutableList.copyOf(this.welcomeFiles);
        }

        public HttpResourceBinding withWelcomeFile(String welcomeFile) {
            this.welcomeFiles.add(welcomeFile);
            return this;
        }
    }
}

