/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v2.zstd;

import io.airlift.compress.v2.zstd.BitInputStream;
import io.airlift.compress.v2.zstd.BitOutputStream;
import io.airlift.compress.v2.zstd.FseCompressionTable;
import io.airlift.compress.v2.zstd.UnsafeUtil;
import io.airlift.compress.v2.zstd.Util;
import sun.misc.Unsafe;

final class FiniteStateEntropy {
    public static final int MAX_SYMBOL = 255;
    public static final int MAX_TABLE_LOG = 12;
    public static final int MIN_TABLE_LOG = 5;
    private static final int[] REST_TO_BEAT = new int[]{0, 473195, 504333, 520860, 550000, 700000, 750000, 830000};
    private static final short UNASSIGNED = -2;

    private FiniteStateEntropy() {
    }

    public static int decompress(Table table, Object inputBase, long inputAddress, long inputLimit, byte[] outputBuffer) {
        long output;
        long outputAddress;
        block3: {
            byte numberOfBits;
            byte[] outputBase = outputBuffer;
            outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET;
            long outputLimit = outputAddress + (long)outputBuffer.length;
            long input = inputAddress;
            BitInputStream.Initializer initializer = new BitInputStream.Initializer(inputBase, input, inputLimit);
            initializer.initialize();
            int bitsConsumed = initializer.getBitsConsumed();
            long currentAddress = initializer.getCurrentAddress();
            long bits = initializer.getBits();
            int state1 = (int)BitInputStream.peekBits(bitsConsumed, bits, table.log2Size);
            BitInputStream.Loader loader = new BitInputStream.Loader(inputBase, input, currentAddress, bits, bitsConsumed += table.log2Size);
            loader.load();
            bits = loader.getBits();
            bitsConsumed = loader.getBitsConsumed();
            currentAddress = loader.getCurrentAddress();
            int state2 = (int)BitInputStream.peekBits(bitsConsumed, bits, table.log2Size);
            loader = new BitInputStream.Loader(inputBase, input, currentAddress, bits, bitsConsumed += table.log2Size);
            loader.load();
            bits = loader.getBits();
            bitsConsumed = loader.getBitsConsumed();
            currentAddress = loader.getCurrentAddress();
            byte[] symbols = table.symbol;
            byte[] numbersOfBits = table.numberOfBits;
            int[] newStates = table.newState;
            for (output = outputAddress; output <= outputLimit - 4L; output += 4L) {
                UnsafeUtil.UNSAFE.putByte(outputBase, output, symbols[state1]);
                numberOfBits = numbersOfBits[state1];
                state1 = (int)((long)newStates[state1] + BitInputStream.peekBits(bitsConsumed, bits, numberOfBits));
                bitsConsumed += numberOfBits;
                UnsafeUtil.UNSAFE.putByte(outputBase, output + 1L, symbols[state2]);
                numberOfBits = numbersOfBits[state2];
                state2 = (int)((long)newStates[state2] + BitInputStream.peekBits(bitsConsumed, bits, numberOfBits));
                bitsConsumed += numberOfBits;
                UnsafeUtil.UNSAFE.putByte(outputBase, output + 2L, symbols[state1]);
                numberOfBits = numbersOfBits[state1];
                state1 = (int)((long)newStates[state1] + BitInputStream.peekBits(bitsConsumed, bits, numberOfBits));
                bitsConsumed += numberOfBits;
                UnsafeUtil.UNSAFE.putByte(outputBase, output + 3L, symbols[state2]);
                numberOfBits = numbersOfBits[state2];
                state2 = (int)((long)newStates[state2] + BitInputStream.peekBits(bitsConsumed, bits, numberOfBits));
                loader = new BitInputStream.Loader(inputBase, input, currentAddress, bits, bitsConsumed += numberOfBits);
                boolean done = loader.load();
                bitsConsumed = loader.getBitsConsumed();
                bits = loader.getBits();
                currentAddress = loader.getCurrentAddress();
                if (!done) continue;
                break;
            }
            do {
                Util.verify(output <= outputLimit - 2L, input, "Output buffer is too small");
                UnsafeUtil.UNSAFE.putByte(outputBase, output++, symbols[state1]);
                numberOfBits = numbersOfBits[state1];
                state1 = (int)((long)newStates[state1] + BitInputStream.peekBits(bitsConsumed, bits, numberOfBits));
                loader = new BitInputStream.Loader(inputBase, input, currentAddress, bits, bitsConsumed += numberOfBits);
                loader.load();
                bitsConsumed = loader.getBitsConsumed();
                bits = loader.getBits();
                currentAddress = loader.getCurrentAddress();
                if (loader.isOverflow()) {
                    UnsafeUtil.UNSAFE.putByte(outputBase, output++, symbols[state2]);
                    break block3;
                }
                Util.verify(output <= outputLimit - 2L, input, "Output buffer is too small");
                UnsafeUtil.UNSAFE.putByte(outputBase, output++, symbols[state2]);
                byte numberOfBits1 = numbersOfBits[state2];
                state2 = (int)((long)newStates[state2] + BitInputStream.peekBits(bitsConsumed, bits, numberOfBits1));
                loader = new BitInputStream.Loader(inputBase, input, currentAddress, bits, bitsConsumed += numberOfBits1);
                loader.load();
                bitsConsumed = loader.getBitsConsumed();
                bits = loader.getBits();
                currentAddress = loader.getCurrentAddress();
            } while (!loader.isOverflow());
            UnsafeUtil.UNSAFE.putByte(outputBase, output++, symbols[state1]);
        }
        return (int)(output - outputAddress);
    }

    public static int compress(Object outputBase, long outputAddress, int outputSize, byte[] input, int inputSize, FseCompressionTable table) {
        return FiniteStateEntropy.compress(outputBase, outputAddress, outputSize, input, Unsafe.ARRAY_BYTE_BASE_OFFSET, inputSize, table);
    }

    public static int compress(Object outputBase, long outputAddress, int outputSize, Object inputBase, long inputAddress, int inputSize, FseCompressionTable table) {
        int state2;
        int state1;
        long inputLimit;
        Util.checkArgument(outputSize >= 8, "Output buffer too small");
        long start = inputAddress;
        long input = inputLimit = start + (long)inputSize;
        if (inputSize <= 2) {
            return 0;
        }
        BitOutputStream stream = new BitOutputStream(outputBase, outputAddress, outputSize);
        if ((inputSize & 1) != 0) {
            state1 = table.begin(UnsafeUtil.UNSAFE.getByte(inputBase, --input));
            state2 = table.begin(UnsafeUtil.UNSAFE.getByte(inputBase, --input));
            state1 = table.encode(stream, state1, UnsafeUtil.UNSAFE.getByte(inputBase, --input));
            stream.flush();
        } else {
            state2 = table.begin(UnsafeUtil.UNSAFE.getByte(inputBase, --input));
            state1 = table.begin(UnsafeUtil.UNSAFE.getByte(inputBase, --input));
        }
        if (((inputSize -= 2) & 2) != 0) {
            state2 = table.encode(stream, state2, UnsafeUtil.UNSAFE.getByte(inputBase, --input));
            state1 = table.encode(stream, state1, UnsafeUtil.UNSAFE.getByte(inputBase, --input));
            stream.flush();
        }
        while (input > start) {
            state2 = table.encode(stream, state2, UnsafeUtil.UNSAFE.getByte(inputBase, --input));
            state1 = table.encode(stream, state1, UnsafeUtil.UNSAFE.getByte(inputBase, --input));
            state2 = table.encode(stream, state2, UnsafeUtil.UNSAFE.getByte(inputBase, --input));
            state1 = table.encode(stream, state1, UnsafeUtil.UNSAFE.getByte(inputBase, --input));
            stream.flush();
        }
        table.finish(stream, state2);
        table.finish(stream, state1);
        return stream.close();
    }

    public static int optimalTableLog(int maxTableLog, int inputSize, int maxSymbol) {
        if (inputSize <= 1) {
            throw new IllegalArgumentException();
        }
        int result = maxTableLog;
        result = Math.min(result, Util.highestBit(inputSize - 1) - 2);
        result = Math.max(result, Util.minTableLog(inputSize, maxSymbol));
        result = Math.max(result, 5);
        result = Math.min(result, 12);
        return result;
    }

    public static int normalizeCounts(short[] normalizedCounts, int tableLog, int[] counts, int total, int maxSymbol) {
        Util.checkArgument(tableLog >= 5, "Unsupported FSE table size");
        Util.checkArgument(tableLog <= 12, "FSE table size too large");
        Util.checkArgument(tableLog >= Util.minTableLog(total, maxSymbol), "FSE table size too small");
        long scale = 62 - tableLog;
        long step = 0x4000000000000000L / (long)total;
        long vstep = 1L << (int)(scale - 20L);
        int stillToDistribute = 1 << tableLog;
        int largest = 0;
        short largestProbability = 0;
        int lowThreshold = total >>> tableLog;
        for (int symbol = 0; symbol <= maxSymbol; ++symbol) {
            long restToBeat;
            long delta;
            if (counts[symbol] == total) {
                throw new IllegalArgumentException();
            }
            if (counts[symbol] == 0) {
                normalizedCounts[symbol] = 0;
                continue;
            }
            if (counts[symbol] <= lowThreshold) {
                normalizedCounts[symbol] = -1;
                --stillToDistribute;
                continue;
            }
            short probability = (short)((long)counts[symbol] * step >>> (int)scale);
            if (probability < 8 && (delta = (long)counts[symbol] * step - ((long)probability << (int)scale)) > (restToBeat = vstep * (long)REST_TO_BEAT[probability])) {
                probability = (short)(probability + 1);
            }
            if (probability > largestProbability) {
                largestProbability = probability;
                largest = symbol;
            }
            normalizedCounts[symbol] = probability;
            stillToDistribute -= probability;
        }
        if (-stillToDistribute >= normalizedCounts[largest] >>> 1) {
            FiniteStateEntropy.normalizeCounts2(normalizedCounts, tableLog, counts, total, maxSymbol);
        } else {
            int n = largest;
            normalizedCounts[n] = (short)(normalizedCounts[n] + (short)stillToDistribute);
        }
        return tableLog;
    }

    private static int normalizeCounts2(short[] normalizedCounts, int tableLog, int[] counts, int total, int maxSymbol) {
        int i;
        int distributed = 0;
        int lowThreshold = total >>> tableLog;
        int lowOne = total * 3 >>> tableLog + 1;
        for (int i2 = 0; i2 <= maxSymbol; ++i2) {
            if (counts[i2] == 0) {
                normalizedCounts[i2] = 0;
                continue;
            }
            if (counts[i2] <= lowThreshold) {
                normalizedCounts[i2] = -1;
                ++distributed;
                total -= counts[i2];
                continue;
            }
            if (counts[i2] <= lowOne) {
                normalizedCounts[i2] = 1;
                ++distributed;
                total -= counts[i2];
                continue;
            }
            normalizedCounts[i2] = -2;
        }
        int normalizationFactor = 1 << tableLog;
        int toDistribute = normalizationFactor - distributed;
        if (total / toDistribute > lowOne) {
            lowOne = total * 3 / (toDistribute * 2);
            for (i = 0; i <= maxSymbol; ++i) {
                if (normalizedCounts[i] != -2 || counts[i] > lowOne) continue;
                normalizedCounts[i] = 1;
                ++distributed;
                total -= counts[i];
            }
            toDistribute = normalizationFactor - distributed;
        }
        if (distributed == maxSymbol + 1) {
            int maxValue = 0;
            int maxCount = 0;
            for (int i3 = 0; i3 <= maxSymbol; ++i3) {
                if (counts[i3] <= maxCount) continue;
                maxValue = i3;
                maxCount = counts[i3];
            }
            int n = maxValue;
            normalizedCounts[n] = (short)(normalizedCounts[n] + (short)toDistribute);
            return 0;
        }
        if (total == 0) {
            i = 0;
            while (toDistribute > 0) {
                if (normalizedCounts[i] > 0) {
                    --toDistribute;
                    int n = i;
                    normalizedCounts[n] = (short)(normalizedCounts[n] + 1);
                }
                i = (i + 1) % (maxSymbol + 1);
            }
            return 0;
        }
        long vStepLog = 62 - tableLog;
        long mid = (1L << (int)(vStepLog - 1L)) - 1L;
        long rStep = ((1L << (int)vStepLog) * (long)toDistribute + mid) / (long)total;
        long tmpTotal = mid;
        for (int i4 = 0; i4 <= maxSymbol; ++i4) {
            if (normalizedCounts[i4] != -2) continue;
            long end = tmpTotal + (long)counts[i4] * rStep;
            int sEnd = (int)(end >>> (int)vStepLog);
            int sStart = (int)(tmpTotal >>> (int)vStepLog);
            int weight = sEnd - sStart;
            if (weight < 1) {
                throw new AssertionError();
            }
            normalizedCounts[i4] = (short)weight;
            tmpTotal = end;
        }
        return 0;
    }

    public static int writeNormalizedCounts(Object outputBase, long outputAddress, int outputSize, short[] normalizedCounts, int maxSymbol, int tableLog) {
        Util.checkArgument(tableLog <= 12, "FSE table too large");
        Util.checkArgument(tableLog >= 5, "FSE table too small");
        long output = outputAddress;
        long outputLimit = outputAddress + (long)outputSize;
        int tableSize = 1 << tableLog;
        int bitCount = 0;
        int bitStream = tableLog - 5;
        bitCount += 4;
        int remaining = tableSize + 1;
        int threshold = tableSize;
        int tableBitCount = tableLog + 1;
        int symbol = 0;
        boolean previousIs0 = false;
        while (remaining > 1) {
            if (previousIs0) {
                int start = symbol;
                while (normalizedCounts[symbol] == 0) {
                    ++symbol;
                }
                while (symbol >= start + 24) {
                    start += 24;
                    Util.checkArgument(output + 2L <= outputLimit, "Output buffer too small");
                    UnsafeUtil.UNSAFE.putShort(outputBase, output, (short)(bitStream |= 65535 << bitCount));
                    output += 2L;
                    bitStream >>>= 16;
                }
                while (symbol >= start + 3) {
                    start += 3;
                    bitStream |= 3 << bitCount;
                    bitCount += 2;
                }
                bitStream |= symbol - start << bitCount;
                if ((bitCount += 2) > 16) {
                    Util.checkArgument(output + 2L <= outputLimit, "Output buffer too small");
                    UnsafeUtil.UNSAFE.putShort(outputBase, output, (short)bitStream);
                    output += 2L;
                    bitStream >>>= 16;
                    bitCount -= 16;
                }
            }
            int count = normalizedCounts[symbol++];
            int max = 2 * threshold - 1 - remaining;
            remaining -= count < 0 ? -count : count;
            if (++count >= threshold) {
                count += max;
            }
            bitStream |= count << bitCount;
            bitCount += tableBitCount;
            bitCount -= count < max ? 1 : 0;
            boolean bl = previousIs0 = count == 1;
            if (remaining < 1) {
                throw new AssertionError();
            }
            while (remaining < threshold) {
                --tableBitCount;
                threshold >>= 1;
            }
            if (bitCount <= 16) continue;
            Util.checkArgument(output + 2L <= outputLimit, "Output buffer too small");
            UnsafeUtil.UNSAFE.putShort(outputBase, output, (short)bitStream);
            output += 2L;
            bitStream >>>= 16;
            bitCount -= 16;
        }
        Util.checkArgument(output + 2L <= outputLimit, "Output buffer too small");
        UnsafeUtil.UNSAFE.putShort(outputBase, output, (short)bitStream);
        Util.checkArgument(symbol <= maxSymbol + 1, "Error");
        return (int)((output += (long)((bitCount + 7) / 8)) - outputAddress);
    }

    public static final class Table {
        int log2Size;
        final int[] newState;
        final byte[] symbol;
        final byte[] numberOfBits;

        public Table(int log2Capacity) {
            int capacity = 1 << log2Capacity;
            this.newState = new int[capacity];
            this.symbol = new byte[capacity];
            this.numberOfBits = new byte[capacity];
        }

        public Table(int log2Size, int[] newState, byte[] symbol, byte[] numberOfBits) {
            int size = 1 << log2Size;
            if (newState.length != size || symbol.length != size || numberOfBits.length != size) {
                throw new IllegalArgumentException("Expected arrays to match provided size");
            }
            this.log2Size = log2Size;
            this.newState = newState;
            this.symbol = symbol;
            this.numberOfBits = numberOfBits;
        }
    }
}

