/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v2.lz4;

import io.airlift.compress.v2.lz4.Lz4Compressor;
import io.airlift.compress.v2.lz4.Lz4Native;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;

public final class Lz4NativeCompressor
implements Lz4Compressor {
    private final MemorySegment state = Arena.ofAuto().allocate(Lz4Native.STATE_SIZE);

    public Lz4NativeCompressor() {
        Lz4Native.verifyEnabled();
    }

    public static boolean isEnabled() {
        return Lz4Native.isEnabled();
    }

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return Lz4Native.maxCompressedLength(uncompressedSize);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        MemorySegment inputSegment = MemorySegment.ofArray(input).asSlice((long)inputOffset, inputLength);
        MemorySegment outputSegment = MemorySegment.ofArray(output).asSlice((long)outputOffset, maxOutputLength);
        return Lz4Native.compress(inputSegment, inputLength, outputSegment, maxOutputLength, 1, this.state);
    }

    @Override
    public int compress(MemorySegment input, MemorySegment output) {
        return Lz4Native.compress(input, Math.toIntExact(input.byteSize()), output, Math.toIntExact(output.byteSize()), 1, this.state);
    }
}

