/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v2.deflate;

import io.airlift.compress.v2.Decompressor;
import io.airlift.compress.v2.MalformedInputException;
import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class DeflateDecompressor
implements Decompressor {
    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        DeflateDecompressor.verifyRange(input, inputOffset, inputLength);
        DeflateDecompressor.verifyRange(output, outputOffset, maxOutputLength);
        Inflater inflater = new Inflater(true);
        try {
            int uncompressedLength;
            block7: {
                inflater.setInput(input, inputOffset, inputLength);
                uncompressedLength = 0;
                do {
                    uncompressedLength += inflater.inflate(output, outputOffset + uncompressedLength, maxOutputLength - uncompressedLength);
                    if (inflater.finished() || uncompressedLength >= maxOutputLength) break block7;
                } while (!inflater.needsInput());
                throw new MalformedInputException(0L, String.format("Premature end of input stream. Input length = %s, uncompressed length = %d", inputLength, uncompressedLength));
            }
            if (!inflater.finished()) {
                throw new MalformedInputException(0L, "Output buffer too small");
            }
            int n = uncompressedLength;
            return n;
        }
        catch (DataFormatException e) {
            throw new RuntimeException("Invalid compressed stream", e);
        }
        finally {
            inflater.end();
        }
    }

    @Override
    public int decompress(MemorySegment input, MemorySegment output) throws MalformedInputException {
        ByteBuffer inputByteBuffer = input.asByteBuffer();
        Inflater inflater = new Inflater(true);
        try {
            inflater.setInput(inputByteBuffer);
            ByteBuffer outputByteBuffer = output.asByteBuffer();
            int uncompressedLength = 0;
            while (!inflater.finished() && (long)(uncompressedLength += inflater.inflate(outputByteBuffer)) < output.byteSize()) {
                if (!inflater.needsInput()) continue;
                throw new MalformedInputException(inputByteBuffer.position(), "Premature end of input stream. Input length = " + input.byteSize() + ", uncompressed length = " + uncompressedLength);
            }
            if (!inflater.finished()) {
                throw new MalformedInputException(inputByteBuffer.position(), "Could not decompress all input (output buffer too small?)");
            }
            int n = uncompressedLength;
            return n;
        }
        catch (DataFormatException e) {
            throw new RuntimeException("Invalid compressed stream", e);
        }
        finally {
            inflater.end();
        }
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

