/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.installation;

import android.content.Context;
import android.content.Intent;
import io.airbridge.AirBridge;
import io.airbridge.Session;
import io.airbridge.deeplink.DeepLink;
import io.airbridge.installation.SimpleLink;
import io.airbridge.integration.IntegrationManager;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import io.airbridge.internal.tasks.CompletableFuture;
import io.airbridge.statistics.Attribution;
import io.airbridge.statistics.StateContainer;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.InstallEvent;
import org.json.JSONObject;

public class Installer {
    public static CompletableFuture<String> referrerFuture = new CompletableFuture();
    private static boolean tooLongToDeferredAction;
    private static int referrerTimeout;

    public static void setPlayStoreReferrerTimeout(int millis) {
        referrerTimeout = millis;
    }

    public static void install(final Context context, boolean doReferrerTimeout) {
        if (doReferrerTimeout) {
            AirBridgeExecutor.runAfterTime(5, new Runnable(){

                @Override
                public void run() {
                    tooLongToDeferredAction = true;
                }
            });
        }
        Session.getCurrent().setInstalled();
        if (StateContainer.get() == StateContainer.State.INSTALL_WITH_DEEP_LINK) {
            Logger.d("Skipping InstallEvent because the app is installed with deep link.", new Object[0]);
            return;
        }
        IntegrationManager.notifyInstalled(context);
        String referrer = referrerFuture.await(referrerTimeout);
        InstallEvent installEvent = new InstallEvent(referrer);
        AirBridge.getTracker().call(installEvent, new Tracker.EventCallback(){

            @Override
            public void done(JSONObject results) throws Exception {
                Installer.finishInstall(context, results);
            }
        });
    }

    private static void finishInstall(Context context, JSONObject serverResult) throws Exception {
        if (serverResult.has("lastTouchpoint")) {
            JSONObject deferredData = serverResult.getJSONObject("lastTouchpoint");
            if (tooLongToDeferredAction) {
                Logger.d("Ignoring calling handler due to the late response from server.", new Object[0]);
            } else if (deferredData != null) {
                String simpleLink = deferredData.getString("simplelink");
                SimpleLink.callHandler(new SimpleLink(simpleLink), context);
                if (deferredData.has("deeplink")) {
                    String deeplink = deferredData.getString("deeplink");
                    Intent intent = DeepLink.createIntent(deeplink);
                    context.startActivity(intent);
                }
            }
            Attribution.getInstance().update(context);
        }
        StateContainer.set(StateContainer.State.INIT_FINISHED);
    }

    static {
        referrerTimeout = 1500;
    }
}

