/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.deeplink;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.net.Uri;
import io.airbridge.DeepLinkActivity;
import io.airbridge.Link;
import io.airbridge.deeplink.AnnotationScanner;
import io.airbridge.deeplink.Router;
import io.airbridge.internal.log.Logger;

public class DeepLink
extends Link {
    static Router router;

    public static void init(Context context) {
        if (DeepLink.hasRouterActivityRegistered(context)) {
            Logger.d("Using Airbridge DeepLink Router.", new Object[0]);
            router = new Router();
            AnnotationScanner.scanAndRegister(context, router);
        }
    }

    private static boolean hasRouterActivityRegistered(Context context) {
        String routerActivityName = DeepLinkActivity.class.getName();
        try {
            ActivityInfo[] activities;
            for (ActivityInfo activity : activities = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)1).activities) {
                if (!activity.name.equals(routerActivityName)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Router getRouter() {
        return router;
    }

    public static Intent createIntent(String deepLinkUri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.setData(Uri.parse((String)deepLinkUri));
        return intent;
    }

    public static boolean hadOpened(Activity activity) {
        return activity.getIntent() != null && "android.intent.action.VIEW".equals(activity.getIntent().getAction());
    }

    public static DeepLink fromActivity(Activity activity) {
        if (!DeepLink.hadOpened(activity)) {
            return null;
        }
        return new DeepLink(activity.getIntent().getData().toString());
    }

    public DeepLink(String uriString) {
        super(uriString);
    }

    public static interface Filter {
        public boolean filter(Context var1, DeepLink var2);
    }

    public static interface Handler {
        public void onLink(Context var1, DeepLink var2);
    }
}

