package io.airbridge.statistics.events;

import io.airbridge.Session;
import io.airbridge.deeplink.DeepLink;
import io.airbridge.internal.networking.Param;
import io.airbridge.statistics.StateContainer;
import io.airbridge.statistics.Tracker;

import static io.airbridge.statistics.StateContainer.State.DEEP_LINK_CLICKED;
import static io.airbridge.statistics.StateContainer.State.INSTALL_WITH_DEEP_LINK;

/**
 * @author Hyojun Kim
 */
public class DeepLinkLaunchEvent extends Event {

    private static final int LAUNCH_EVENT_CATEGORY = 9162;
    private static final int FIRST_LAUNCH_EVENT_CATEGORY = 9163;

    private String deeplinkUri;

    public DeepLinkLaunchEvent(DeepLink link) {
        this(link.toString());
    }

    public DeepLinkLaunchEvent(String deeplinkUri) {
        this.deeplinkUri = deeplinkUri;
    }

    @Override
    public void onBeforeSendingEvent() {
        super.onBeforeSendingEvent();
        StateContainer.set(DEEP_LINK_CLICKED);

        if (Session.getCurrent().isFirstTime()) {
            StateContainer.set(INSTALL_WITH_DEEP_LINK);
        }
    }

    @Override
    public Param getEventData(Tracker tracker) {
        return new Param().put("deeplink", deeplinkUri);
    }

    @Override
    public int getCategory() {
        // 딥링크를 이용한 설치 (State.INSTALL_WITH_DEEP_LINK) 시에는 예외적으로 9163번 이벤트를 보내야 한다.
        return StateContainer.get() == INSTALL_WITH_DEEP_LINK
                ? FIRST_LAUNCH_EVENT_CATEGORY
                : LAUNCH_EVENT_CATEGORY;
    }
}
