package io.airbridge.statistics.events;

/**
 * @author Hyojun Kim
 */
public class BackgroundEvent extends Event {

    private static final int EVENT_CATEGORY = 9269;

    @Override
    public int getCategory() {
        return EVENT_CATEGORY;
    }

    @Override
    public boolean isImportant() {
        // 앱 종료 상황에서 BackgroundEvent가 원래 AppShutdownEvent보다 먼저 발생하지만,
        // race condition으로 인해 AppShutdownEvent보다 늦게 보내져 이벤트 순서가 꼬이는 문제가 있다.
        return true;
    }
}
