package io.airbridge;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;

import io.airbridge.deeplink.DeepLink;
import io.airbridge.internal.log.Logger;
import io.airbridge.statistics.events.DeepLinkLaunchEvent;

/**
 * AirBridge를 통해 넘어오는 모든 딥 링크를 받는 Activity이다.
 *
 * <p>
 *     <b>반드시</b> AndroidManifest.xml에 io.udl.DeepLinkActivity를
 *     android.intent.action.VIEW 액션, android.intent.category.DEFAULT 카테고리 및
 *     android.intent.category.BROWSABLE 카테고리로 등록해주어야 딥 링크를 사용할 수 있다.
 * </p>
 */
public class DeepLinkActivity extends Activity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // get link
        Intent intent = getIntent();
        if (intent == null) {
            finish();
            return;
        }

        try {
            String uri = intent.getData().toString();
            DeepLink.getRouter().callHandlers(new DeepLink(uri), this);
            AirBridge.getTracker().send(new DeepLinkLaunchEvent(uri));
            finish();

        } catch (Throwable e) {
            Logger.wtf("An error occurred while handling deep link.", e);
        }
    }
}
