package io.airbridge;

/**
 * SDK Constants.
 * Copyright (C) 2015 AB180. All rights are reserved.
 */
public class Constants {
    // referenced from build.gradle
    public static final String VERSION = BuildConfig.SDK_VERSION;

    public static final String HOST = "https://core.airbridge.io";
    public static final String DEV_HOST = "http://core.dev.airbridge.io";
    public static final String SECONDARY_HOST = "https://secondary.airbridge.io/sqs/airbridge-mobile-events";
    public static final String STATS_ENDPOINT = "/api/v2/apps/";

    // maximum request retry delay. (sec)
    public static final int MAX_RETRY_DELAY = 1024;

    // 얼마나 레퍼러 인텐트 수신을 기다릴지 설정. (ms)
    public static final int DEFAULT_REFERRER_TIMEOUT = 1500;

    // 얼마나 UUID (GAID) 받아오기를 기다릴 지 결정. (ms)
    public static final int UUID_WAIT_TIMEOUT = 4500;

    /**
     * Install이 아닌 평상시에 Launch 이벤트를 띄울때 지연시킬 시간.
     * 혹시 딥링크 실행이 발생하면 Launch 이벤트를 Init Thread에서 중복해서 띄우면 안되기 때문에
     * 지연을 걸고 이후 딥링크 발생 여부를 체크하여, 딥링크 발생시엔 Launch를 중복으로 보내지 않는다.
     */
    public static final int LAUNCH_DELAY = 5000;

    public static final String LOG_TAG = "AirBridge";

    public static final String PREFS = "ab_session";

    public static final String BLACKBOX_FILE_NAME = ".ab_logs";

    /**
     * Dev 서버를 사용할 것인가?
     */
    public static Boolean isDevelopConstants = false;

    public static String getHost() {
        return isDevelopConstants ? DEV_HOST : HOST;
    }
}
