/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics.page;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.os.Build;
import io.airbridge.internal.log.Logger;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.PageViewEvent;
import io.airbridge.statistics.page.AppActiveState;
import io.airbridge.statistics.page.LifecycleTracker;
import io.airbridge.statistics.page.PageInfo;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PageTracker {
    private Tracker tracker;
    PageInfo currentPageInfo = new PageInfo();
    private Map<String, PageInfo> pageInfoCache = new HashMap<String, PageInfo>();
    volatile AppActiveState previousState;
    volatile AppActiveState currentState;

    public PageTracker(Context context, Tracker tracker) {
        this.tracker = tracker;
        this.previousState = this.currentState = AppActiveState.OFF;
        this.registerActivityLifecycleHandler(context);
    }

    private void registerActivityLifecycleHandler(Context context) {
        if (Build.VERSION.SDK_INT >= 14) {
            LifecycleTracker lifecycleCallback = new LifecycleTracker(this, this.tracker);
            Application app = (Application)context.getApplicationContext();
            app.registerComponentCallbacks((ComponentCallbacks)lifecycleCallback);
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)lifecycleCallback);
        }
    }

    void setCurrentState(AppActiveState state) {
        if (this.previousState == state && this.currentState == state) {
            return;
        }
        Logger.v("State change : " + this.currentState.name() + " -> " + state.name(), new Object[0]);
        this.previousState = this.currentState;
        this.currentState = state;
    }

    public int getPreviousState() {
        return this.previousState.state;
    }

    public void setCurrentPage(Activity activity) {
        PageInfo pageInfo = this.pageInfoCache.get(activity.getClass().getName());
        if (pageInfo == null) {
            pageInfo = new PageInfo(activity);
            this.pageInfoCache.put(activity.getClass().getName(), pageInfo);
        }
        pageInfo.activity = new WeakReference<Activity>(activity);
        this.currentPageInfo = pageInfo;
        if (this.tracker.isPageTrackingEnabled()) {
            this.tracker.send(new PageViewEvent());
        }
    }

    public void setCurrentPageName(String name) {
        if (this.currentPageInfo == null) {
            throw new IllegalStateException("You need to set current page first.");
        }
        this.currentPageInfo.name = name;
    }

    public void setCurrentPageData(String key, Object value) {
        if (this.currentPageInfo == null) {
            throw new IllegalStateException("You need to set current page first.");
        }
        this.currentPageInfo.customInfo.put(key, value);
    }

    public Activity getCurrentActivity() {
        if (this.currentPageInfo == null) {
            throw new IllegalStateException("You need to set current page first.");
        }
        return (Activity)this.currentPageInfo.activity.get();
    }

    public JSONObject getCurrentPageData() {
        return this.currentPageInfo != null ? this.currentPageInfo.toJson() : new JSONObject();
    }
}

