/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import io.airbridge.AirBridge;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.ABRequest;
import io.airbridge.internal.networking.ABResponse;
import io.airbridge.internal.networking.Param;
import io.airbridge.internal.networking.RequestQueue;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import io.airbridge.statistics.DeviceInfo;
import io.airbridge.statistics.StateContainer;
import io.airbridge.statistics.events.DeepLinkLaunchEvent;
import io.airbridge.statistics.events.Event;
import io.airbridge.statistics.page.PageTracker;
import org.json.JSONException;
import org.json.JSONObject;

public class Tracker {
    private RequestQueue queue;
    public PageTracker pageTracker;
    private Param locationInfo;
    private Param userInfo;
    private boolean pageTrackingEnabled = false;

    public Tracker(Context context) {
        this.queue = new RequestQueue(context);
        this.pageTracker = new PageTracker(context, this);
    }

    public void setPageTrackingEnabled(boolean pageTrackingEnabled) {
        this.pageTrackingEnabled = pageTrackingEnabled;
    }

    public boolean isPageTrackingEnabled() {
        return this.pageTrackingEnabled;
    }

    public void setUserEmail(String email) {
        if (this.userInfo == null) {
            this.userInfo = new Param();
        }
        this.userInfo.put("externalUserEmail", email);
    }

    public void setUserId(String userId) {
        if (this.userInfo == null) {
            this.userInfo = new Param();
        }
        this.userInfo.put("externalUserID", userId);
    }

    public void setLocationData(Location location) {
        this.locationInfo = new Param().put("latitude", location.getLatitude()).put("longitude", location.getLongitude()).put("altitude", location.getAltitude()).put("speed", Float.valueOf(location.getSpeed()));
    }

    public void send(final Event event) {
        if (!event.canBeSent()) {
            return;
        }
        AirBridgeExecutor.run(new Runnable(){

            @Override
            public void run() {
                StateContainer.waitFor(StateContainer.State.DEVICE_INFO_FETCHED, 4500L);
                event.onBeforeSendingEvent();
                ABRequest request = Tracker.this.makeEventRequest(event);
                if (event.isImportant()) {
                    Tracker.this.queue.sendNow(request);
                } else {
                    Tracker.this.queue.enqueue(request);
                }
            }
        });
    }

    public void onNewIntent(Intent intent) {
        if ("android.intent.action.VIEW".equals(intent.getAction()) && intent.getData() != null) {
            this.send(new DeepLinkLaunchEvent(intent.getDataString()));
        }
    }

    public void call(final Event event, final EventCallback callback) {
        if (!event.canBeSent()) {
            return;
        }
        AirBridgeExecutor.run(new Runnable(){

            @Override
            public void run() {
                StateContainer.waitFor(StateContainer.State.DEVICE_INFO_FETCHED, 4500L);
                event.onBeforeSendingEvent();
                Tracker.this.makeEventRequest(event).callAsync(new ABRequest.Callback(){

                    @Override
                    public void done(ABRequest request, ABResponse response) {
                        if (response.isFailed()) {
                            Logger.e("Failed to send event.");
                            return;
                        }
                        try {
                            JSONObject json = new JSONObject(response.body);
                            callback.done(json.getJSONObject("resource"));
                        }
                        catch (JSONException e) {
                            Logger.e("Failed to parse JSON.", e);
                        }
                        catch (Throwable e) {
                            Logger.wtf("An error occurred while processing event result.", e);
                        }
                    }
                });
            }
        });
    }

    private ABRequest makeEventRequest(Event event) {
        Logger.v("Event occurred : %s (%d)", event.getClass().getSimpleName(), event.getCategory());
        DeviceInfo device = DeviceInfo.getInstance();
        Param payload = new Param().put("eventTimestamp", System.currentTimeMillis()).put("sdkVersion", "M_A_v1.0.0-beta5").put("app", this.getApplicationData(device));
        Param deviceData = device.serialize();
        deviceData.put("limitAppTracking", !this.pageTrackingEnabled);
        if (this.locationInfo != null) {
            deviceData.put("location", this.locationInfo);
        }
        payload.put("device", deviceData);
        if (this.userInfo != null) {
            payload.put("user", this.userInfo);
        }
        Param eventData = event.getEventData(this);
        eventData.put("exActiveStatus", this.pageTracker.getPreviousState());
        eventData.put("page", this.pageTracker.getCurrentPageData());
        payload.put("eventData", eventData);
        String url = "/api/v2/apps/" + AirBridge.appId + "/events/mobile-app/" + event.getCategory();
        return new ABRequest("POST", url).setParameter(payload);
    }

    private Param getApplicationData(DeviceInfo device) {
        return new Param().put("version", device.appVersion).put("versionCode", device.appVersionCode).put("packageName", device.packageName);
    }

    public static interface EventCallback {
        public void done(JSONObject var1) throws Exception;
    }
}

