/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.installation;

import android.content.Context;
import io.airbridge.AirBridge;
import io.airbridge.Session;
import io.airbridge.deeplink.DeepLink;
import io.airbridge.installation.SimpleLink;
import io.airbridge.integration.IntegrationManager;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import io.airbridge.internal.tasks.CompletableFuture;
import io.airbridge.statistics.Attribution;
import io.airbridge.statistics.StateContainer;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.InstallEvent;
import org.json.JSONObject;

public class Installer {
    public static CompletableFuture<String> referrerFuture = new CompletableFuture();
    private static boolean tooLongToDeferredAction;
    private static int referrerTimeout;

    public static void setPlayStoreReferrerTimeout(int millis) {
        referrerTimeout = millis;
    }

    public static void install(final Context context, boolean doReferrerTimeout) {
        if (doReferrerTimeout) {
            AirBridgeExecutor.runAfterTime(5, new Runnable(){

                @Override
                public void run() {
                    tooLongToDeferredAction = true;
                }
            });
        }
        Session.getCurrent().setInstalled();
        String referrer = referrerFuture.await(referrerTimeout);
        if (StateContainer.get() == StateContainer.State.INSTALL_WITH_DEEP_LINK) {
            Logger.d("Skipping InstallEvent because the app is installed with deep link.", new Object[0]);
            StateContainer.set(StateContainer.State.INIT_FINISHED);
            return;
        }
        IntegrationManager.notifyInstalled(context);
        InstallEvent installEvent = new InstallEvent(referrer);
        AirBridge.getTracker().call(installEvent, new Tracker.EventCallback(){

            @Override
            public void done(JSONObject results) throws Exception {
                Installer.finishInstall(context, results);
            }
        });
    }

    private static void finishInstall(Context context, JSONObject serverResult) throws Exception {
        if (!serverResult.has("lastTouchpoint")) {
            return;
        }
        JSONObject deferredData = serverResult.getJSONObject("lastTouchpoint");
        if (tooLongToDeferredAction) {
            Logger.d("Ignoring calling handler due to the late response from server.", new Object[0]);
        } else if (deferredData != null) {
            String simpleLink = deferredData.getString("simplelink");
            SimpleLink.callHandler(new SimpleLink(simpleLink), context);
            if (deferredData.has("deeplink")) {
                String deeplink = deferredData.getString("deeplink");
                DeepLink.getRouter().callHandlers(new DeepLink(deeplink), context);
            }
        }
        StateContainer.set(StateContainer.State.INIT_FINISHED);
        Attribution.getInstance().update(context);
    }

    static {
        referrerTimeout = 1500;
    }
}

