/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.SystemClock;
import io.airbridge.Session;
import io.airbridge.deeplink.DeepLink;
import io.airbridge.installation.Installer;
import io.airbridge.integration.IntegrationManager;
import io.airbridge.integration.Integrator;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.RequestQueue;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import io.airbridge.statistics.DeviceInfo;
import io.airbridge.statistics.StateContainer;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.DeepLinkLaunchEvent;
import io.airbridge.statistics.events.GoalEvent;
import io.airbridge.statistics.events.LaunchEvent;
import io.airbridge.statistics.goals.SignUpGoalBuilder;
import io.airbridge.statistics.page.PageTracker;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class AirBridge {
    private static final String NUMBER_FILTER = "^-?\\d+$";
    public static String appId;
    public static String appToken;
    public static boolean isDebugMode;
    public static boolean isAppDebuggable;
    private static boolean doInstallCheck;
    private static boolean doReferrerTimeout;
    private static Session session;
    private static Tracker tracker;

    public static void init(Context context, String appName, String userToken) {
        if (appName == null) {
            throw new IllegalArgumentException("App Name was not given!");
        }
        if (userToken == null) {
            throw new IllegalArgumentException("User Token was not given!");
        }
        context = context.getApplicationContext();
        appId = appName;
        appToken = userToken;
        AirBridge.fetchAppDebuggable(context);
        if (isAppDebuggable) {
            if (appName.matches(NUMBER_FILTER)) {
                throw new IllegalArgumentException("App name must be a sub-domain name of your Airbridge App; Seems like you haven't been migrated from old version.\nPlease migrate according to http://docs.airbridge.io/ko/start/1-3-1.html");
            }
            if (appToken.contains("ey") && appToken.contains(".")) {
                throw new IllegalArgumentException("You're using user token from old version, not app token; Seems like you haven't been migrated from old version.\nPlease migrate according to http://docs.airbridge.io/ko/start/1-3-1.html");
            }
        }
        try {
            Session.init(context);
            session = Session.getCurrent();
            tracker = new Tracker(context);
            DeepLink.init(context);
            AirBridgeExecutor.run(new InitializerTask(context));
        }
        catch (Throwable e) {
            Logger.wtf("Error occurred while initializing", e);
        }
    }

    public static void initCordovaSDK(Context context, String appName, String userToken) {
        doReferrerTimeout = false;
        AirBridge.init(context, appName, userToken);
    }

    public static Tracker getTracker() {
        return tracker;
    }

    public static PageTracker getPageTracker() {
        return AirBridge.tracker.pageTracker;
    }

    public static void turnOnIntegration(Integrator integrator) {
        IntegrationManager.registerIntegration(integrator);
    }

    public static void deepLinkClicked(String uri) {
        tracker.send(new DeepLinkLaunchEvent(uri));
    }

    public static void userSignup(String value) {
        GoalEvent event = new SignUpGoalBuilder().setUserId(value).build();
        tracker.send(event);
    }

    public static void userSignin(String value) {
        GoalEvent event = new SignUpGoalBuilder().setUserId(value).build();
        tracker.send(event);
    }

    public static void goal(String label) {
        AirBridge.goal(label, label, null);
    }

    public static void goal(String label, String category) {
        AirBridge.goal(label, category, null);
    }

    public static void goal(String label, String category, String key) {
        tracker.send(new GoalEvent(category).setLabel(label).setCustomAttribute("key", key));
    }

    public static void setDebugMode(boolean enabled) {
        isDebugMode = enabled;
    }

    public static void setEnsureRequestMode(boolean enabled) {
        RequestQueue.ensureRequestMode = enabled;
    }

    static void disableInstallCheck() {
        doInstallCheck = false;
    }

    private static void fetchAppDebuggable(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            Signature[] signatures = packageInfo.signatures;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (Signature signature : signatures) {
                ByteArrayInputStream stream = new ByteArrayInputStream(signature.toByteArray());
                X509Certificate cert = (X509Certificate)cf.generateCertificate(stream);
                String certString = cert.getSubjectX500Principal().toString();
                isAppDebuggable = certString.contains("CN=Android Debug") && certString.contains("O=Android");
            }
        }
        catch (Exception ignored) {
            isAppDebuggable = false;
        }
    }

    static {
        doInstallCheck = true;
        doReferrerTimeout = true;
    }

    static class InitializerTask
    implements Runnable {
        private Context context;

        public InitializerTask(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            DeviceInfo.fetch(this.context);
            StateContainer.set(StateContainer.State.DEVICE_INFO_FETCHED);
            if (!doInstallCheck) {
                return;
            }
            if (session.isFirstTime() && StateContainer.get() != StateContainer.State.INSTALL_WITH_DEEP_LINK) {
                Installer.install(this.context, doReferrerTimeout);
            } else {
                SystemClock.sleep((long)5000L);
                tracker.send(new LaunchEvent());
                StateContainer.set(StateContainer.State.INIT_FINISHED);
            }
        }
    }
}

