package io.airbridge.statistics.goals;

import io.airbridge.statistics.events.GoalEvent;

/**
 * 상품 구매시의 목표달성 이벤트를 만든다.
 */
public class PurchaseGoalBuilder {

    int value;
    String currency;

    public PurchaseGoalBuilder(int value) {
        this.value = value;
    }

    /**
     * 구매 금액의 통화 단위를 설정한다. <br>
     *     통화 단위는 <a href="//en.wikipedia.org/wiki/ISO_4217">ISO 4217</a>을 준수해야 한다.
     *
     * @param currency 통화 단위 (ex: KRW, USD)
     * @return {@link PurchaseGoalBuilder}
     */
    public PurchaseGoalBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public GoalEvent build() {
        GoalEvent event = new GoalEvent("airbridge.order", "completed");
        event.setValue(value);
        if (currency != null) {
            event.setCustomAttribute("currency", currency);
        }
        return event;
    }
}
