package io.airbridge.statistics.events;

import io.airbridge.internal.networking.Param;
import io.airbridge.statistics.StateContainer;
import io.airbridge.statistics.Tracker;

/**
 * Launch Event
 * @author Hyojun Kim
 */
public class LaunchEvent extends Event {

    private static final int EVENT_CATEGORY = 9160;

    @Override
    public int getCategory() {
        return EVENT_CATEGORY;
    }

    @Override
    public Param getEventData(Tracker tracker) {
        return new Param();
    }

    @Override
    public boolean isImportant() {
        return true;
    }

    @Override
    public boolean canBeSent() {
        return StateContainer.get() != StateContainer.State.DEEP_LINK_CLICKED;
    }
}