package io.airbridge.internal.log;

import android.content.Context;
import android.os.Build;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

import io.airbridge.Constants;

/**
 * Stores logs to the offline, when {@link Logger#wtf} is occurred.
 */
public class BlackBox {

    private File blackBoxFile;

    private List<LogEntry> logs = new ArrayList<>();


    public BlackBox(Context context) {
        // load from offline.
        File blackBoxDir = Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP
                ? context.getNoBackupFilesDir()
                : context.getFilesDir();

        blackBoxFile = new File(blackBoxDir, Constants.PREFS);
        load();
    }

    public void load() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(blackBoxFile));
            String line;
            while ((line = br.readLine()) != null) {
                logs.add(LogEntry.fromJson(new JSONObject(line)));
            }

        } catch (Exception e) {
            Logger.e("Error occurred while loading BlackBox", e);
        }
    }

    public void save() {
    }

    public boolean hasBlackbox() {
        return logs.size() > 0;
    }
}
