package io.airbridge.deeplink;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;

import io.airbridge.internal.log.Logger;

/**
 * Scans all annotation in activities - in runtime.
 * Copyright (C) 2015 AB180. All rights are reserved.
 */
class AnnotationScanner {

    /**
     * Scan all the activities and make a route map.
     * @param context App Context
     */
    public static void scanAndRegister(Context context, Router router) {
        try {
            ActivityInfo infos[] = context.getPackageManager()
                    .getPackageInfo(context.getPackageName(), PackageManager.GET_ACTIVITIES)
                    .activities;

            for (ActivityInfo info : infos) {
                Class activityClass = Class.forName(info.name,false,context.getClassLoader());
                DeepLinkRoute annotation = (DeepLinkRoute) activityClass.getAnnotation(DeepLinkRoute.class);

                if (annotation != null) {
                    for (String route : annotation.value()) {
                        router.addRoute(route, activityClass);
                        Logger.d("Found @DeepLink activity : %s => %s", route, activityClass.getSimpleName());
                    }
                }

                // search for @DeepLinkDefaultRoute
                DeepLinkDefaultRoute defaultRoute = (DeepLinkDefaultRoute) activityClass.getAnnotation(DeepLinkDefaultRoute.class);
                if (defaultRoute != null) {
                    router.setDefaultHandler(activityClass);
                }
            }
        } catch (Exception e) {
            Logger.w("Failed to addRoute an activity.", e);
        }
    }
}
