package io.airbridge;

import android.net.Uri;
import android.os.Bundle;

import io.airbridge.deeplink.DeepLink;
import io.airbridge.installation.SimpleLink;

/**
 * {@link SimpleLink}, {@link DeepLink}의 원형이 되는 클래스.
 * @author Hyojun Kim
 */
public class Link {

    private Uri uri;
    protected Bundle bundle;

    protected Link(String uriString) {
        this.uri = Uri.parse(uriString);
        this.bundle = getQueryParameters(uri);
    }

    private Bundle getQueryParameters(Uri uri) {
        Bundle params = new Bundle();
        String query = uri.getEncodedQuery();
        if (query == null) return params;

        int start = 0;
        do {
            int next = query.indexOf('&', start);
            int end = (next == -1) ? query.length() : next;

            int separator = query.indexOf('=', start);
            if (separator > end || separator == -1) {
                separator = end;
            }

            String rawName = query.substring(start, separator);
            String name = Uri.decode(rawName);
            params.putString(name, uri.getQueryParameter(name));

            // Move start to end of name.
            start = end + 1;
        } while (start < query.length());
        return params;
    }

    public Object get(String key) {
        return bundle.get(key);
    }

    public int getInt(String key, int defaultValue) {
        try {
            Object value = get(key);
            if (value == null) return defaultValue;
            return value instanceof String ? Integer.valueOf((String) value) : (int) value;

        } catch (Throwable e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            Object value = get(key);
            if (value == null) return defaultValue;
            return value instanceof String ? Boolean.valueOf((String) value) : (boolean) value;

        } catch (Throwable e) {
            return defaultValue;
        }
    }

    public String getString(String key) {
        return getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        try {
            Object value = get(key);
            if (value == null) return defaultValue;
            return (String) get(key);

        } catch (Throwable e) {
            return defaultValue;
        }
    }

    public boolean has(String key) {
        return bundle.containsKey(key);
    }

    public Uri getUri() {
        return uri;
    }

    @Override
    public String toString() {
        return uri.toString();
    }

    public Bundle toBundle() {
        return bundle;
    }
}
