/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics;

import io.airbridge.internal.log.Logger;
import io.airbridge.internal.tasks.CompletableFuture;
import java.util.HashMap;
import java.util.Map;

public class StateContainer {
    private static volatile State currentState = State.APP_STARTED;
    private static volatile Map<State, CompletableFuture<Boolean>> awaiters = new HashMap<State, CompletableFuture<Boolean>>();

    public static State get() {
        return currentState;
    }

    public static void set(State state) {
        Logger.d("Process change : " + (Object)((Object)currentState) + " -> " + (Object)((Object)state), new Object[0]);
        currentState = state;
        if (awaiters.containsKey((Object)state)) {
            awaiters.get((Object)state).complete(true);
        }
    }

    public static void waitFor(State state, long timeout) {
        if (currentState == state) {
            return;
        }
        CompletableFuture<Boolean> future = awaiters.get((Object)state);
        if (future == null || future.isDone()) {
            future = new CompletableFuture();
            awaiters.put(state, future);
        }
        future.await(timeout);
    }

    public static void reset() {
        currentState = State.APP_STARTED;
        awaiters = new HashMap<State, CompletableFuture<Boolean>>();
    }

    public static enum State {
        APP_STARTED,
        DEVICE_INFO_FETCHED,
        INSTALL_WITH_DEEP_LINK,
        DEEP_LINK_CLICKED,
        INIT_FINISHED;

    }
}

