/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.tasks;

import android.annotation.SuppressLint;
import io.airbridge.internal.log.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@SuppressLint(value={"NewApi"})
public class AirBridgeExecutor {
    static final int MAX_BACKGROUND_THREADS = 5;
    static final int TIMER_POOL_SIZE = 10;
    static volatile ExecutorService PARALLEL_EXECUTOR;
    static volatile ScheduledExecutorService TIMER_EXECUTOR;
    static volatile ExecutorService SERIAL_EXECUTOR;

    public static void run(final Runnable runnable) {
        if (PARALLEL_EXECUTOR == null) {
            PARALLEL_EXECUTOR = Executors.newFixedThreadPool(5);
        }
        PARALLEL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    Logger.wtf("Error occurred while running background task", e);
                }
            }
        });
    }

    public static void runAfterTime(int seconds, Runnable runnable) {
        if (TIMER_EXECUTOR == null) {
            TIMER_EXECUTOR = Executors.newScheduledThreadPool(10);
        }
        TIMER_EXECUTOR.schedule(runnable, (long)seconds, TimeUnit.SECONDS);
    }

    public static void runSerialTask(final Runnable runnable) {
        if (SERIAL_EXECUTOR == null) {
            SERIAL_EXECUTOR = Executors.newSingleThreadExecutor();
        }
        SERIAL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    Logger.wtf("Error occurred while running network task", e);
                }
            }
        });
    }
}

