/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.networking;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.ABRequest;
import io.airbridge.internal.networking.ABResponse;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.json.JSONArray;

public class RequestQueue {
    private static final int SEND_DELAY = 5;
    private static final IntentFilter RECONNECT_INTENT = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    public static boolean ensureRequestMode = true;
    private volatile boolean collectingRequests = false;
    private Queue<ABRequest> requestQueue = new LinkedBlockingQueue<ABRequest>();
    private Queue<ABRequest> failQueue = new LinkedBlockingQueue<ABRequest>();
    private SharedPreferences prefs;
    private ConnectivityManager cm;
    private Context context;
    private final ABRequest.Callback responseCallback = new ABRequest.Callback(){

        @Override
        public void done(final ABRequest request, ABResponse response) {
            if (response.isFailed() && response.status != 400) {
                request.retryDelay = request.retryDelay == 0 ? 1 : (request.retryDelay *= 2);
                if (request.retryDelay > 1024) {
                    return;
                }
                RequestQueue.this.addToFailQueue(request);
                AirBridgeExecutor.runAfterTime(request.retryDelay, new Runnable(){

                    @Override
                    public void run() {
                        Logger.v("Retrying request after %d seconds.", request.retryDelay);
                        RequestQueue.this.removeFromFailQueue(request);
                        request.callAsync(RequestQueue.this.responseCallback);
                    }
                });
            }
        }
    };
    private final BroadcastReceiver reconnectReceiver = new BroadcastReceiver(){

        public void onReceive(Context c, Intent intent) {
            if (RequestQueue.this.isNetworkConnected()) {
                RequestQueue.this.context.unregisterReceiver((BroadcastReceiver)this);
                Logger.d("Internet reconnected!", new Object[0]);
                RequestQueue.this.retrySending();
            }
        }
    };

    public RequestQueue(Context context) {
        this.context = context;
        this.prefs = context.getSharedPreferences("ab_session", 0);
        this.cm = (ConnectivityManager)context.getSystemService("connectivity");
        this.loadOfflineQueue();
    }

    private void loadOfflineQueue() {
        if (!ensureRequestMode) {
            return;
        }
        try {
            JSONArray jsonQueue = new JSONArray(this.prefs.getString("queue", "[]"));
            int length = jsonQueue.length();
            for (int i = 0; i < length; ++i) {
                this.failQueue.add(ABRequest.fromJson(jsonQueue.get(i).toString()));
            }
        }
        catch (Exception e) {
            Logger.e("Failed to load offline request queue", e);
        }
    }

    void retrySending() {
        ABRequest request;
        if (!ensureRequestMode) {
            return;
        }
        while ((request = this.failQueue.poll()) != null) {
            if (request.retryDelay > 1024) {
                this.removeFromFailQueue(request);
                continue;
            }
            request.callAsync(this.responseCallback);
        }
        this.saveQueueToOffline();
        Logger.d("Retry sending all request", new Object[0]);
    }

    public void sendNow(ABRequest request) {
        request.shouldBackoff = true;
        if (!this.isNetworkConnected()) {
            this.addToFailQueue(request);
            this.context.registerReceiver(this.reconnectReceiver, RECONNECT_INTENT);
            Logger.d("Internet is not connected - pending request. [waitingQueueLength=%d]", this.failQueue.size());
        } else {
            request.callAsync(this.responseCallback);
            if (!this.failQueue.isEmpty()) {
                this.retrySending();
            }
        }
    }

    public void enqueue(ABRequest request) {
        this.requestQueue.add(request);
        if (this.collectingRequests) {
            return;
        }
        Logger.v("Collecting requests...", new Object[0]);
        this.collectingRequests = true;
        AirBridgeExecutor.runAfterTime(5, new Runnable(){

            @Override
            public void run() {
                ABRequest req;
                Logger.v("Finished collecting. Sending %d requests.", RequestQueue.this.requestQueue.size());
                RequestQueue.this.collectingRequests = false;
                while ((req = (ABRequest)RequestQueue.this.requestQueue.poll()) != null) {
                    RequestQueue.this.sendNow(req);
                }
            }
        });
    }

    private void addToFailQueue(ABRequest request) {
        this.failQueue.add(request);
        this.saveQueueToOffline();
    }

    private void removeFromFailQueue(ABRequest request) {
        this.failQueue.remove(request);
        this.saveQueueToOffline();
    }

    private void saveQueueToOffline() {
        JSONArray jsonQueue = new JSONArray();
        for (ABRequest req : this.failQueue) {
            jsonQueue.put((Object)req.toJson());
        }
        this.prefs.edit().putString("queue", jsonQueue.toString()).apply();
    }

    private boolean isNetworkConnected() {
        NetworkInfo activeNetwork = this.cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
    }
}

