/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.integration;

import android.content.Context;
import io.airbridge.integration.Integrator;
import io.airbridge.statistics.Attribution;
import java.util.ArrayList;
import java.util.List;

public class IntegrationManager {
    static List<Integrator> integrators = new ArrayList<Integrator>();

    public static void registerIntegration(Integrator integrator) {
        integrators.add(integrator);
    }

    public static Integrator getIntegratorByClass(Class<? extends Integrator> integratorClass) {
        for (Integrator integrator : integrators) {
            if (!integrator.getClass().equals(integratorClass)) continue;
            return integrator;
        }
        return null;
    }

    public static void notifyInstalled(Context context) {
        for (Integrator integrator : integrators) {
            integrator.onInstall(context);
        }
    }

    public static void sendAttribution(Attribution attrib, Context context) {
        for (Integrator integrator : integrators) {
            integrator.sendAttribution(context, attrib);
        }
    }

    public static void unregisterAll() {
        integrators.clear();
    }
}

