package io.airbridge.statistics.goals;

import io.airbridge.AirBridge;
import io.airbridge.statistics.events.GoalEvent;

/**
 * 로그인 시의 목표달성 이벤트를 만든다.
 */
public class SignInGoalBuilder {

    private String userId, userEmail;

    public SignInGoalBuilder setUserId(String userId) {
        this.userId = userId;
        AirBridge.getTracker().setUserId(userId);
        return this;
    }

    public SignInGoalBuilder setUserEmail(String userEmail) {
        this.userEmail = userEmail;
        AirBridge.getTracker().setUserId(userEmail);
        return this;
    }

    public GoalEvent build() {
        return new GoalEvent("airbridge.user", "signin");
    }
}
