package io.airbridge.statistics.events;

import io.airbridge.internal.networking.Param;
import io.airbridge.statistics.Tracker;

/**
 * @author Hyojun Kim
 */
public abstract class Event {

    /**
     * Fills request body of a event.
     *
     * @param tracker Tracker instance.
     *
     * @return A {@link Param} object that'll be the payload of the request.
     */
    public Param getEventData(Tracker tracker) { return new Param(); }

    /**
     * Must return unique eventCategory value of an event.
     * @return eventCategory (ex: 9162, 108, 104...)
     */
    public abstract int getCategory();

    /**
     * If this method returns {@code false}, the event will not be sent. <br>
     * Any event can implement this method and control their behavior.
     * (ex: One LAUNCH per day, etc...)
     */
    public boolean canBeSent() {
        return true;
    }

    /**
     * Called before sending event.
     */
    public void onBeforeSendingEvent() {}

    /**
     * If this method returns {@code true}, the event will be sent immediately,
     * and will be sent prior to the other unimportant events.
     * For performance reasons, we recommend not to use important event.
     */
    public boolean isImportant() {
        return false;
    }
}
