package io.airbridge.internal.networking;

import org.json.JSONObject;

import java.util.HashMap;

/**
 * 서버 API 호출 시 보낼 파라미터를 작성할 때 사용된다.
 * Copyright (C) 2015 AB180. All rights are reserved.
 *
 * @author vista
 */
public class Param {
    private HashMap<String, Object> paramMap;

    public Param() {
        paramMap = new HashMap<>();
    }

    public Param put(String key, Object value) {
        paramMap.put(key, value);
        return this;
    }

    public Param put(String key, Param value) {
        paramMap.put(key, value.toJson());
        return this;
    }

    public Object get(String key) {
        return paramMap.get(key);
    }

    /**
     * 파라미터들을 JSON으로 변환한다.
     * @return JSONObject instance
     */
    public JSONObject toJson() {
        return new JSONObject(paramMap);
    }

    @Override
    public String toString() {
        return this.toJson().toString();
    }
}
