package io.airbridge.internal.networking;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import io.airbridge.AirBridge;
import io.airbridge.internal.log.Logger;

/**
 * ABHttpClient - ABRequest를 보내는 역할을 수행한다.
 * @author Hyojun Kim
 */
class ABHttpClient {

    /**
     * 리퀘스트를 보낼 때의 버퍼 크기. 512바이트
     */
    private static final int BUFFER_SIZE = 512;

    public ABResponse call(ABRequest request) throws Exception {
        HttpURLConnection connection = null;

        try {
            URL url = new URL(request.getUrl());
            connection = (HttpURLConnection) url.openConnection();

            connection.setRequestMethod(request.getMethod());
            connection.setRequestProperty("Authorization", "AIRBRIDGE-APP-TOKEN " + AirBridge.appToken);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Accept-Encoding", "utf-8");
            connection.setRequestProperty("Content-Type", "application/json");

            if (!request.getMethod().equals("GET")) {
                connection.setDoOutput(true);
                connection.setChunkedStreamingMode(0);

                OutputStream out = new BufferedOutputStream(connection.getOutputStream(), BUFFER_SIZE);
                out.write(request.getParam().getBytes("utf-8"));
                out.flush();
                out.close();
            }

            InputStream stream;
            int code = connection.getResponseCode();
            if (code >= 400) stream = connection.getErrorStream();
            else stream = connection.getInputStream();

            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            String line;
            StringBuilder body = new StringBuilder();
            while ((line = in.readLine()) != null) body.append(line);
            in.close();

            return new ABResponse(code, body.toString());

        } catch (OutOfMemoryError err) {
            // flush 과정에서 OOM이 나는 경우가 존재한다.
            Logger.wtf("Out of memory error occurred.", err);

        } finally {
            if (connection != null) connection.disconnect();
        }
        // error
        return new ABResponse(1000);
    }
}
