package io.airbridge.deeplink;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Deep Link Annotation.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface DeepLinkRoute {
    /**
     * The path of the route
     */
    String[] value();

    /**
     * 해당 라우트에 관한 설명
     */
    String desc() default "(none)";
}
