/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics.page;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.AppShutdownEvent;
import io.airbridge.statistics.events.BackgroundEvent;
import io.airbridge.statistics.page.AppActiveState;
import io.airbridge.statistics.page.PageTracker;

@SuppressLint(value={"NewApi"})
class LifecycleTracker
implements Application.ActivityLifecycleCallbacks,
ComponentCallbacks2 {
    private PageTracker pageTracker;
    private Tracker tracker;
    private boolean isInForeground = false;
    private volatile boolean isBackgroundEventCancelled = false;

    LifecycleTracker(PageTracker pageTracker, Tracker tracker) {
        this.pageTracker = pageTracker;
        this.tracker = tracker;
    }

    public void onActivityResumed(Activity activity) {
        if (!this.isInForeground) {
            this.isInForeground = true;
            Logger.d("App is on foreground.", new Object[0]);
        } else if (activity.getClass().getName().equals(this.pageTracker.currentPageInfo.componentName)) {
            return;
        }
        this.pageTracker.setCurrentState(AppActiveState.ACTIVE);
        this.pageTracker.setCurrentPage(activity);
    }

    public void onActivityDestroyed(Activity activity) {
        String destroyedActivityName = activity.getClass().getName();
        String currentActivityName = this.pageTracker.currentPageInfo.componentName;
        if (activity.isTaskRoot() && destroyedActivityName.equals(currentActivityName)) {
            Logger.d("App is shutting down.", new Object[0]);
            this.isBackgroundEventCancelled = true;
            this.pageTracker.setCurrentState(AppActiveState.OFF);
            this.tracker.send(new AppShutdownEvent());
        }
    }

    public void onTrimMemory(int level) {
        if (level == 20 && this.isInForeground) {
            this.isInForeground = false;
            AirBridgeExecutor.runAfterTime(2, new Runnable(){

                @Override
                public void run() {
                    if (LifecycleTracker.this.isBackgroundEventCancelled) {
                        LifecycleTracker.this.isBackgroundEventCancelled = false;
                        return;
                    }
                    LifecycleTracker.this.pageTracker.setCurrentState(AppActiveState.INACTIVE);
                    LifecycleTracker.this.tracker.send(new BackgroundEvent());
                }
            });
            Logger.d("App is on background.", new Object[0]);
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onLowMemory() {
    }
}

