/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.networking;

import android.os.Handler;
import android.os.Looper;
import io.airbridge.Constants;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.ABHttpClient;
import io.airbridge.internal.networking.ABResponse;
import io.airbridge.internal.networking.Param;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.json.JSONException;
import org.json.JSONObject;

public class ABRequest {
    private static ABHttpClient httpClient = new ABHttpClient();
    protected String url;
    protected String method;
    protected JSONObject param;
    boolean shouldBackoff = false;
    int retryDelay = 0;
    private boolean retryingToSecondaryServer = false;
    private static Handler handler;

    static void setHttpClient(ABHttpClient client) {
        httpClient = client;
    }

    public static ABRequest fromJson(String str) throws JSONException {
        JSONObject data = new JSONObject(str);
        ABRequest request = new ABRequest(data.getString("requestMethod"), data.getString("requestEndpoint"));
        request.param = data.getJSONObject("requestBody");
        request.retryDelay = data.getInt("retryDelay");
        request.shouldBackoff = data.getBoolean("shouldBackoff");
        return request;
    }

    public ABRequest(String method, String url) {
        this.method = method;
        this.url = url;
        this.param = new JSONObject();
    }

    public void callAsync(final Callback callback) {
        final ABRequest request = this;
        AirBridgeExecutor.runSerialTask(new Runnable(){

            @Override
            public void run() {
                try {
                    request.param.put("requestTimestamp", System.currentTimeMillis());
                    Logger.v("Request    => %s %s", request.getUrl(), request.param);
                    final ABResponse response = httpClient.call(request);
                    Logger.v("\u2514 Response => HTTP %d, %s", response.status, response.body);
                    if (response.isFailed()) {
                        if (response.status == 401) {
                            throw new Exception("Unauthorized Error. Please reissue the app token in Dashboard.");
                        }
                        if (response.status == 404 || response.status >= 500) {
                            if (!ABRequest.this.retryingToSecondaryServer) {
                                if (ABRequest.this.shouldBackoff) {
                                    throw new Exception("Internal server error. Retrying in minutes...");
                                }
                                Logger.d("Internal server error occured. Trying again to SQS...", new Object[0]);
                                ABRequest.this.retryingToSecondaryServer = true;
                                ABRequest.this.callAsync(callback);
                                return;
                            }
                            ABRequest.this.retryingToSecondaryServer = false;
                            throw new Exception("Internal server error.");
                        }
                    } else if (ABRequest.this.retryingToSecondaryServer) {
                        ABRequest.this.retryingToSecondaryServer = false;
                    }
                    if (response.status == 204) {
                        return;
                    }
                    ABRequest.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.done(request, response);
                        }
                    });
                }
                catch (ConnectException | UnknownHostException e) {
                    Logger.e("Request failed - Internet not connected.");
                    if (ABRequest.this.retryingToSecondaryServer) {
                        ABRequest.this.retryingToSecondaryServer = false;
                    }
                    ABRequest.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.done(request, new ABResponse(1000));
                        }
                    });
                }
                catch (Exception e) {
                    Logger.e("Request failed - " + request.param, e);
                    ABRequest.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ABRequest.this.retryingToSecondaryServer) {
                                return;
                            }
                            callback.done(request, new ABResponse(1000));
                        }
                    });
                }
            }
        });
    }

    private void runOnUiThread(Runnable action) {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        handler.post(action);
    }

    public ABRequest setParameter(Param param) {
        this.param = param.toJson();
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public final String getUrl() {
        return this.isRetryingToSecondaryServer() ? "https://secondary.airbridge.io/sqs/airbridge-mobile-events" : Constants.getHost() + this.url;
    }

    public boolean isRetryingToSecondaryServer() {
        return this.retryingToSecondaryServer;
    }

    public String getParam() {
        if (this.isRetryingToSecondaryServer()) {
            try {
                JSONObject sqsRequest = this.toJson();
                sqsRequest.put("requestEndpoint", (Object)(Constants.getHost() + sqsRequest.getString("requestEndpoint")));
                return sqsRequest.toString();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return this.param.toString();
    }

    public JSONObject toJson() {
        try {
            JSONObject self = new JSONObject();
            self.put("requestMethod", (Object)this.method);
            self.put("requestEndpoint", (Object)this.url);
            self.put("requestBody", (Object)this.param);
            self.put("retryDelay", this.retryDelay);
            self.put("shouldBackoff", this.shouldBackoff);
            return self;
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    public String toString() {
        return this.param.toString();
    }

    public static interface Callback {
        public void done(ABRequest var1, ABResponse var2);
    }
}

